/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.ssl;

import org.springframework.boot.autoconfigure.ssl.JksSslBundleProperties;
import org.springframework.boot.autoconfigure.ssl.PemSslBundleProperties;
import org.springframework.boot.autoconfigure.ssl.SslBundleProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundleKey;
import org.springframework.boot.ssl.SslManagerBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.boot.ssl.jks.JksSslStoreBundle;
import org.springframework.boot.ssl.jks.JksSslStoreDetails;
import org.springframework.boot.ssl.pem.PemSslStoreBundle;
import org.springframework.boot.ssl.pem.PemSslStoreDetails;

public final class PropertiesSslBundle
implements SslBundle {
    private final SslStoreBundle stores;
    private final SslBundleKey key;
    private final SslOptions options;
    private final String protocol;
    private final SslManagerBundle managers;

    private PropertiesSslBundle(SslStoreBundle stores, SslBundleProperties properties) {
        this.stores = stores;
        this.key = PropertiesSslBundle.asSslKeyReference(properties.getKey());
        this.options = PropertiesSslBundle.asSslOptions(properties.getOptions());
        this.protocol = properties.getProtocol();
        this.managers = SslManagerBundle.from((SslStoreBundle)this.stores, (SslBundleKey)this.key);
    }

    private static SslBundleKey asSslKeyReference(SslBundleProperties.Key key) {
        return key != null ? SslBundleKey.of((String)key.getPassword(), (String)key.getAlias()) : SslBundleKey.NONE;
    }

    private static SslOptions asSslOptions(SslBundleProperties.Options options) {
        return options != null ? SslOptions.of(options.getCiphers(), options.getEnabledProtocols()) : SslOptions.NONE;
    }

    public SslStoreBundle getStores() {
        return this.stores;
    }

    public SslBundleKey getKey() {
        return this.key;
    }

    public SslOptions getOptions() {
        return this.options;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public SslManagerBundle getManagers() {
        return this.managers;
    }

    public static SslBundle get(PemSslBundleProperties properties) {
        return new PropertiesSslBundle(PropertiesSslBundle.asSslStoreBundle(properties), properties);
    }

    public static SslBundle get(JksSslBundleProperties properties) {
        return new PropertiesSslBundle(PropertiesSslBundle.asSslStoreBundle(properties), properties);
    }

    private static SslStoreBundle asSslStoreBundle(PemSslBundleProperties properties) {
        PemSslStoreDetails keyStoreDetails = PropertiesSslBundle.asStoreDetails(properties.getKeystore());
        PemSslStoreDetails trustStoreDetails = PropertiesSslBundle.asStoreDetails(properties.getTruststore());
        return new PemSslStoreBundle(keyStoreDetails, trustStoreDetails, properties.getKey().getAlias());
    }

    private static PemSslStoreDetails asStoreDetails(PemSslBundleProperties.Store properties) {
        return new PemSslStoreDetails(properties.getType(), properties.getCertificate(), properties.getPrivateKey(), properties.getPrivateKeyPassword());
    }

    private static SslStoreBundle asSslStoreBundle(JksSslBundleProperties properties) {
        JksSslStoreDetails keyStoreDetails = PropertiesSslBundle.asStoreDetails(properties.getKeystore());
        JksSslStoreDetails trustStoreDetails = PropertiesSslBundle.asStoreDetails(properties.getTruststore());
        return new JksSslStoreBundle(keyStoreDetails, trustStoreDetails);
    }

    private static JksSslStoreDetails asStoreDetails(JksSslBundleProperties.Store properties) {
        return new JksSslStoreDetails(properties.getType(), properties.getProvider(), properties.getLocation(), properties.getPassword());
    }
}

