/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.web.servlet;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.actuate.metrics.AutoTimer;
import org.springframework.boot.actuate.metrics.web.servlet.WebMvcTagsProvider;
import org.springframework.core.annotation.MergedAnnotationCollectors;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.NestedServletException;

public class WebMvcMetricsFilter
extends OncePerRequestFilter {
    private final MeterRegistry registry;
    private final WebMvcTagsProvider tagsProvider;
    private final String metricName;
    private final AutoTimer autoTimer;

    public WebMvcMetricsFilter(MeterRegistry registry, WebMvcTagsProvider tagsProvider, String metricName, AutoTimer autoTimer) {
        this.registry = registry;
        this.tagsProvider = tagsProvider;
        this.metricName = metricName;
        this.autoTimer = autoTimer;
    }

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        TimingContext timingContext = TimingContext.get(request);
        if (timingContext == null) {
            timingContext = this.startAndAttachTimingContext(request);
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            if (!request.isAsyncStarted()) {
                Throwable exception = (Throwable)request.getAttribute(DispatcherServlet.EXCEPTION_ATTRIBUTE);
                this.record(timingContext, request, response, exception);
            }
        }
        catch (NestedServletException ex) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            this.record(timingContext, request, response, ex.getCause());
            throw ex;
        }
        catch (IOException | RuntimeException | ServletException ex) {
            this.record(timingContext, request, response, ex);
            throw ex;
        }
    }

    private TimingContext startAndAttachTimingContext(HttpServletRequest request) {
        Timer.Sample timerSample = Timer.start((MeterRegistry)this.registry);
        TimingContext timingContext = new TimingContext(timerSample);
        timingContext.attachTo(request);
        return timingContext;
    }

    private void record(TimingContext timingContext, HttpServletRequest request, HttpServletResponse response, Throwable exception) {
        Object handler = this.getHandler(request);
        Set<Timed> annotations = this.getTimedAnnotations(handler);
        Timer.Sample timerSample = timingContext.getTimerSample();
        if (annotations.isEmpty()) {
            if (this.autoTimer.isEnabled()) {
                Timer.Builder builder = this.autoTimer.builder(this.metricName);
                timerSample.stop(this.getTimer(builder, handler, request, response, exception));
            }
        } else {
            for (Timed annotation : annotations) {
                Timer.Builder builder = Timer.builder((Timed)annotation, (String)this.metricName);
                timerSample.stop(this.getTimer(builder, handler, request, response, exception));
            }
        }
    }

    private Object getHandler(HttpServletRequest request) {
        return request.getAttribute(HandlerMapping.BEST_MATCHING_HANDLER_ATTRIBUTE);
    }

    private Set<Timed> getTimedAnnotations(Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return Collections.emptySet();
        }
        return this.getTimedAnnotations((HandlerMethod)handler);
    }

    private Set<Timed> getTimedAnnotations(HandlerMethod handler) {
        Set<Timed> methodAnnotations = this.findTimedAnnotations(handler.getMethod());
        if (!methodAnnotations.isEmpty()) {
            return methodAnnotations;
        }
        return this.findTimedAnnotations(handler.getBeanType());
    }

    private Set<Timed> findTimedAnnotations(AnnotatedElement element) {
        MergedAnnotations annotations = MergedAnnotations.from((AnnotatedElement)element);
        if (!annotations.isPresent(Timed.class)) {
            return Collections.emptySet();
        }
        return (Set)annotations.stream(Timed.class).collect(MergedAnnotationCollectors.toAnnotationSet());
    }

    private Timer getTimer(Timer.Builder builder, Object handler, HttpServletRequest request, HttpServletResponse response, Throwable exception) {
        return builder.tags(this.tagsProvider.getTags(request, response, handler, exception)).register(this.registry);
    }

    private static class TimingContext {
        private static final String ATTRIBUTE = TimingContext.class.getName();
        private final Timer.Sample timerSample;

        TimingContext(Timer.Sample timerSample) {
            this.timerSample = timerSample;
        }

        Timer.Sample getTimerSample() {
            return this.timerSample;
        }

        void attachTo(HttpServletRequest request) {
            request.setAttribute(ATTRIBUTE, (Object)this);
        }

        static TimingContext get(HttpServletRequest request) {
            return (TimingContext)request.getAttribute(ATTRIBUTE);
        }
    }
}

