/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.management;

import java.io.Closeable;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

@WebEndpoint(id="heapdump")
public class HeapDumpWebEndpoint {
    private final long timeout;
    private final Lock lock = new ReentrantLock();
    private HeapDumper heapDumper;

    public HeapDumpWebEndpoint() {
        this(TimeUnit.SECONDS.toMillis(10L));
    }

    protected HeapDumpWebEndpoint(long timeout) {
        this.timeout = timeout;
    }

    @ReadOperation
    public WebEndpointResponse<Resource> heapDump(@Nullable Boolean live) {
        block7: {
            if (!this.lock.tryLock(this.timeout, TimeUnit.MILLISECONDS)) break block7;
            try {
                WebEndpointResponse<Resource> webEndpointResponse = new WebEndpointResponse<Resource>(this.dumpHeap(live == null ? true : live));
                this.lock.unlock();
                return webEndpointResponse;
            }
            catch (Throwable throwable) {
                try {
                    this.lock.unlock();
                    throw throwable;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException ex) {
                    return new WebEndpointResponse<Resource>(500);
                }
                catch (HeapDumperUnavailableException ex) {
                    return new WebEndpointResponse<Resource>(503);
                }
            }
        }
        return new WebEndpointResponse<Resource>(429);
    }

    private Resource dumpHeap(boolean live) throws IOException, InterruptedException {
        if (this.heapDumper == null) {
            this.heapDumper = this.createHeapDumper();
        }
        File file = this.createTempFile(live);
        this.heapDumper.dumpHeap(file, live);
        return new TemporaryFileSystemResource(file);
    }

    private File createTempFile(boolean live) throws IOException {
        String date = new SimpleDateFormat("yyyy-MM-dd-HH-mm").format(new Date());
        File file = File.createTempFile("heapdump" + date + (live ? "-live" : ""), ".hprof");
        file.delete();
        return file;
    }

    protected HeapDumper createHeapDumper() throws HeapDumperUnavailableException {
        return new HotSpotDiagnosticMXBeanHeapDumper();
    }

    private static final class TemporaryFileSystemResource
    extends FileSystemResource {
        private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

        private TemporaryFileSystemResource(File file) {
            super(file);
        }

        public ReadableByteChannel readableChannel() throws IOException {
            final ReadableByteChannel readableChannel = super.readableChannel();
            return new ReadableByteChannel(){

                @Override
                public boolean isOpen() {
                    return readableChannel.isOpen();
                }

                @Override
                public void close() throws IOException {
                    this.closeThenDeleteFile(readableChannel);
                }

                @Override
                public int read(ByteBuffer dst) throws IOException {
                    return readableChannel.read(dst);
                }
            };
        }

        public InputStream getInputStream() throws IOException {
            return new FilterInputStream(super.getInputStream()){

                @Override
                public void close() throws IOException {
                    this.closeThenDeleteFile(this.in);
                }
            };
        }

        private void closeThenDeleteFile(Closeable closeable) throws IOException {
            try {
                closeable.close();
            }
            finally {
                this.deleteFile();
            }
        }

        private void deleteFile() {
            try {
                Files.delete(this.getFile().toPath());
            }
            catch (IOException ex) {
                this.logger.warn((Object)("Failed to delete temporary heap dump file '" + this.getFile() + "'"), (Throwable)ex);
            }
        }

        public boolean isFile() {
            return false;
        }
    }

    protected static class HeapDumperUnavailableException
    extends RuntimeException {
        public HeapDumperUnavailableException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    protected static class HotSpotDiagnosticMXBeanHeapDumper
    implements HeapDumper {
        private Object diagnosticMXBean;
        private Method dumpHeapMethod;

        protected HotSpotDiagnosticMXBeanHeapDumper() {
            try {
                Class diagnosticMXBeanClass = ClassUtils.resolveClassName((String)"com.sun.management.HotSpotDiagnosticMXBean", null);
                this.diagnosticMXBean = ManagementFactory.getPlatformMXBean(diagnosticMXBeanClass);
                this.dumpHeapMethod = ReflectionUtils.findMethod((Class)diagnosticMXBeanClass, (String)"dumpHeap", (Class[])new Class[]{String.class, Boolean.TYPE});
            }
            catch (Throwable ex) {
                throw new HeapDumperUnavailableException("Unable to locate HotSpotDiagnosticMXBean", ex);
            }
        }

        @Override
        public void dumpHeap(File file, boolean live) {
            ReflectionUtils.invokeMethod((Method)this.dumpHeapMethod, (Object)this.diagnosticMXBean, (Object[])new Object[]{file.getAbsolutePath(), live});
        }
    }

    @FunctionalInterface
    protected static interface HeapDumper {
        public void dumpHeap(File var1, boolean var2) throws IOException, InterruptedException;
    }
}

