/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.wavefront;

import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.clients.WavefrontClient;
import java.time.Duration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.actuate.autoconfigure.wavefront.WavefrontProperties;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.util.unit.DataSize;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={WavefrontSender.class})
@EnableConfigurationProperties(value={WavefrontProperties.class})
public class WavefrontSenderConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={WavefrontTracingOrMetricsCondition.class})
    public WavefrontSender wavefrontSender(WavefrontProperties properties) {
        WavefrontClient.Builder builder = new WavefrontClient.Builder(properties.getEffectiveUri().toString(), properties.getWavefrontApiTokenType(), properties.getApiTokenOrThrow());
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        WavefrontProperties.Sender sender = properties.getSender();
        map.from((Object)sender.getMaxQueueSize()).to(arg_0 -> ((WavefrontClient.Builder)builder).maxQueueSize(arg_0));
        map.from((Object)sender.getFlushInterval()).asInt(Duration::getSeconds).to(arg_0 -> ((WavefrontClient.Builder)builder).flushIntervalSeconds(arg_0));
        map.from((Object)sender.getMessageSize()).asInt(DataSize::toBytes).to(arg_0 -> ((WavefrontClient.Builder)builder).messageSizeBytes(arg_0));
        map.from((Object)sender.getBatchSize()).to(arg_0 -> ((WavefrontClient.Builder)builder).batchSize(arg_0));
        return builder.build();
    }

    static final class WavefrontTracingOrMetricsCondition
    extends AnyNestedCondition {
        WavefrontTracingOrMetricsCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnEnabledMetricsExport(value="wavefront")
        static class MetricsCondition {
            MetricsCondition() {
            }
        }

        @ConditionalOnEnabledTracing(value="wavefront")
        static class TracingCondition {
            TracingCondition() {
            }
        }
    }
}

