/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.metrics.AutoTimeProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.ServiceLevelObjectiveBoundary;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="management.metrics")
public class MetricsProperties {
    private boolean useGlobalRegistry = true;
    private final Map<String, Boolean> enable = new LinkedHashMap<String, Boolean>();
    private final Map<String, String> tags = new LinkedHashMap<String, String>();
    private final Web web = new Web();
    private final Data data = new Data();
    private final Distribution distribution = new Distribution();

    public boolean isUseGlobalRegistry() {
        return this.useGlobalRegistry;
    }

    public void setUseGlobalRegistry(boolean useGlobalRegistry) {
        this.useGlobalRegistry = useGlobalRegistry;
    }

    public Map<String, Boolean> getEnable() {
        return this.enable;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Web getWeb() {
        return this.web;
    }

    public Data getData() {
        return this.data;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public static class Distribution {
        private final Map<String, Boolean> percentilesHistogram = new LinkedHashMap<String, Boolean>();
        private final Map<String, double[]> percentiles = new LinkedHashMap<String, double[]>();
        private final Map<String, ServiceLevelObjectiveBoundary[]> slo = new LinkedHashMap<String, ServiceLevelObjectiveBoundary[]>();
        private final Map<String, String> minimumExpectedValue = new LinkedHashMap<String, String>();
        private final Map<String, String> maximumExpectedValue = new LinkedHashMap<String, String>();

        public Map<String, Boolean> getPercentilesHistogram() {
            return this.percentilesHistogram;
        }

        public Map<String, double[]> getPercentiles() {
            return this.percentiles;
        }

        public Map<String, ServiceLevelObjectiveBoundary[]> getSlo() {
            return this.slo;
        }

        public Map<String, String> getMinimumExpectedValue() {
            return this.minimumExpectedValue;
        }

        public Map<String, String> getMaximumExpectedValue() {
            return this.maximumExpectedValue;
        }
    }

    public static class Data {
        private final Repository repository = new Repository();

        public Repository getRepository() {
            return this.repository;
        }

        public static class Repository {
            private String metricName = "spring.data.repository.invocations";
            @NestedConfigurationProperty
            private final AutoTimeProperties autotime = new AutoTimeProperties();

            public String getMetricName() {
                return this.metricName;
            }

            public void setMetricName(String metricName) {
                this.metricName = metricName;
            }

            public AutoTimeProperties getAutotime() {
                return this.autotime;
            }
        }
    }

    public static class Web {
        private final Client client = new Client();
        private final Server server = new Server();

        public Client getClient() {
            return this.client;
        }

        public Server getServer() {
            return this.server;
        }

        public static class Server {
            private final ServerRequest request = new ServerRequest();
            private int maxUriTags = 100;

            public ServerRequest getRequest() {
                return this.request;
            }

            public int getMaxUriTags() {
                return this.maxUriTags;
            }

            public void setMaxUriTags(int maxUriTags) {
                this.maxUriTags = maxUriTags;
            }

            public static class ServerRequest {
                private String metricName = "http.server.requests";
                private boolean ignoreTrailingSlash = true;
                @NestedConfigurationProperty
                private final AutoTimeProperties autotime = new AutoTimeProperties();

                public AutoTimeProperties getAutotime() {
                    return this.autotime;
                }

                public String getMetricName() {
                    return this.metricName;
                }

                public void setMetricName(String metricName) {
                    this.metricName = metricName;
                }

                public boolean isIgnoreTrailingSlash() {
                    return this.ignoreTrailingSlash;
                }

                public void setIgnoreTrailingSlash(boolean ignoreTrailingSlash) {
                    this.ignoreTrailingSlash = ignoreTrailingSlash;
                }
            }
        }

        public static class Client {
            private final ClientRequest request = new ClientRequest();
            private int maxUriTags = 100;

            public ClientRequest getRequest() {
                return this.request;
            }

            public int getMaxUriTags() {
                return this.maxUriTags;
            }

            public void setMaxUriTags(int maxUriTags) {
                this.maxUriTags = maxUriTags;
            }

            public static class ClientRequest {
                private String metricName = "http.client.requests";
                @NestedConfigurationProperty
                private final AutoTimeProperties autotime = new AutoTimeProperties();

                public AutoTimeProperties getAutotime() {
                    return this.autotime;
                }

                public String getMetricName() {
                    return this.metricName;
                }

                public void setMetricName(String metricName) {
                    this.metricName = metricName;
                }
            }
        }
    }
}

