/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.security.Principal;
import java.util.Collection;
import java.util.function.Predicate;
import org.springframework.boot.actuate.autoconfigure.health.HealthProperties;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.health.HealthEndpointGroup;
import org.springframework.boot.actuate.health.HttpCodeStatusMapper;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

class AutoConfiguredHealthEndpointGroup
implements HealthEndpointGroup {
    private final Predicate<String> members;
    private final StatusAggregator statusAggregator;
    private final HttpCodeStatusMapper httpCodeStatusMapper;
    private final HealthProperties.Show showComponents;
    private final HealthProperties.Show showDetails;
    private final Collection<String> roles;

    AutoConfiguredHealthEndpointGroup(Predicate<String> members, StatusAggregator statusAggregator, HttpCodeStatusMapper httpCodeStatusMapper, HealthProperties.Show showComponents, HealthProperties.Show showDetails, Collection<String> roles) {
        this.members = members;
        this.statusAggregator = statusAggregator;
        this.httpCodeStatusMapper = httpCodeStatusMapper;
        this.showComponents = showComponents;
        this.showDetails = showDetails;
        this.roles = roles;
    }

    public boolean isMember(String name) {
        return this.members.test(name);
    }

    public boolean showComponents(SecurityContext securityContext) {
        if (this.showComponents == null) {
            return this.showDetails(securityContext);
        }
        return this.getShowResult(securityContext, this.showComponents);
    }

    public boolean showDetails(SecurityContext securityContext) {
        return this.getShowResult(securityContext, this.showDetails);
    }

    private boolean getShowResult(SecurityContext securityContext, HealthProperties.Show show) {
        switch (show) {
            case NEVER: {
                return false;
            }
            case ALWAYS: {
                return true;
            }
            case WHEN_AUTHORIZED: {
                return this.isAuthorized(securityContext);
            }
        }
        throw new IllegalStateException("Unsupported 'show' value " + (Object)((Object)show));
    }

    private boolean isAuthorized(SecurityContext securityContext) {
        Principal principal = securityContext.getPrincipal();
        if (principal == null) {
            return false;
        }
        if (CollectionUtils.isEmpty(this.roles)) {
            return true;
        }
        boolean checkAuthorities = this.isSpringSecurityAuthentication(principal);
        for (String role : this.roles) {
            if (securityContext.isUserInRole(role)) {
                return true;
            }
            if (!checkAuthorities) continue;
            Authentication authentication = (Authentication)principal;
            for (GrantedAuthority authority : authentication.getAuthorities()) {
                String name = authority.getAuthority();
                if (!role.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSpringSecurityAuthentication(Principal principal) {
        return ClassUtils.isPresent((String)"org.springframework.security.core.Authentication", null) && principal instanceof Authentication;
    }

    public StatusAggregator getStatusAggregator() {
        return this.statusAggregator;
    }

    public HttpCodeStatusMapper getHttpCodeStatusMapper() {
        return this.httpCodeStatusMapper;
    }
}

