/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.AbstractSwaggerUiConfigProperties;
import org.springdoc.core.SpringDocConfiguration;
import org.springdoc.core.SpringDocPropertiesUtils;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.CollectionUtils;

@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={SpringDocConfiguration.class})
public class SwaggerUiConfigParameters
extends AbstractSwaggerUiConfigProperties {
    public static final String CONFIG_URL_PROPERTY = "configUrl";
    public static final String LAYOUT_PROPERTY = "layout";
    public static final String FILTER_PROPERTY = "filter";
    public static final String URL_PROPERTY = "url";
    public static final String URLS_PROPERTY = "urls";
    public static final String OAUTH2_REDIRECT_URL_PROPERTY = "oauth2RedirectUrl";
    public static final String VALIDATOR_URL_PROPERTY = "validatorUrl";
    public static final String QUERY_CONFIG_ENABLED_PROPERTY = "queryConfigEnabled";
    private String uiRootPath;
    private final SwaggerUiConfigProperties swaggerUiConfig;

    public SwaggerUiConfigParameters(SwaggerUiConfigProperties swaggerUiConfig) {
        this.swaggerUiConfig = swaggerUiConfig;
        this.path = (String)StringUtils.defaultIfBlank((CharSequence)swaggerUiConfig.getPath(), (CharSequence)"/swagger-ui.html");
        this.oauth2RedirectUrl = (String)StringUtils.defaultIfBlank((CharSequence)swaggerUiConfig.getOauth2RedirectUrl(), (CharSequence)"/swagger-ui/oauth2-redirect.html");
        this.layout = swaggerUiConfig.getLayout();
        this.configUrl = swaggerUiConfig.getConfigUrl();
        this.validatorUrl = swaggerUiConfig.getValidatorUrl();
        this.filter = swaggerUiConfig.getFilter();
        this.operationsSorter = swaggerUiConfig.getOperationsSorter();
        this.tagsSorter = swaggerUiConfig.getTagsSorter();
        this.deepLinking = swaggerUiConfig.getDeepLinking();
        this.displayOperationId = swaggerUiConfig.getDisplayOperationId();
        this.defaultModelExpandDepth = swaggerUiConfig.getDefaultModelExpandDepth();
        this.defaultModelsExpandDepth = swaggerUiConfig.getDefaultModelsExpandDepth();
        this.defaultModelRendering = swaggerUiConfig.getDefaultModelRendering();
        this.displayRequestDuration = swaggerUiConfig.getDisplayRequestDuration();
        this.docExpansion = swaggerUiConfig.getDocExpansion();
        this.maxDisplayedTags = swaggerUiConfig.getMaxDisplayedTags();
        this.showCommonExtensions = swaggerUiConfig.getShowCommonExtensions();
        this.showExtensions = swaggerUiConfig.getShowExtensions();
        this.supportedSubmitMethods = swaggerUiConfig.getSupportedSubmitMethods();
        this.url = swaggerUiConfig.getUrl();
        this.urls = swaggerUiConfig.getUrls() == null ? new HashSet() : swaggerUiConfig.getUrls();
        this.urlsPrimaryName = swaggerUiConfig.getUrlsPrimaryName();
        this.groupsOrder = swaggerUiConfig.getGroupsOrder();
        this.tryItOutEnabled = swaggerUiConfig.getTryItOutEnabled();
        this.persistAuthorization = swaggerUiConfig.getPersistAuthorization();
        this.queryConfigEnabled = swaggerUiConfig.getQueryConfigEnabled();
    }

    public void addGroup(String group) {
        AbstractSwaggerUiConfigProperties.SwaggerUrl swaggerUrl = new AbstractSwaggerUiConfigProperties.SwaggerUrl(group);
        this.urls.add(swaggerUrl);
    }

    public void addUrl(String url) {
        this.urls.forEach(elt -> {
            if (!this.isSwaggerUrlDefined(elt.getName())) {
                elt.setUrl(url + "/" + elt.getName());
            }
        });
    }

    public String getUiRootPath() {
        return this.uiRootPath;
    }

    public void setUiRootPath(String uiRootPath) {
        this.uiRootPath = uiRootPath;
    }

    public boolean isValidUrl(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Map<String, Object> getConfigParameters() {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        params.put(VALIDATOR_URL_PROPERTY, this.validatorUrl != null ? this.validatorUrl : "");
        SpringDocPropertiesUtils.put(CONFIG_URL_PROPERTY, this.configUrl, params);
        SpringDocPropertiesUtils.put("deepLinking", this.deepLinking, params);
        SpringDocPropertiesUtils.put("displayOperationId", this.displayOperationId, params);
        SpringDocPropertiesUtils.put("defaultModelsExpandDepth", this.defaultModelsExpandDepth, params);
        SpringDocPropertiesUtils.put("defaultModelExpandDepth", this.defaultModelExpandDepth, params);
        SpringDocPropertiesUtils.put("defaultModelRendering", this.defaultModelRendering, params);
        SpringDocPropertiesUtils.put("displayRequestDuration", this.displayRequestDuration, params);
        SpringDocPropertiesUtils.put("docExpansion", this.docExpansion, params);
        SpringDocPropertiesUtils.put("maxDisplayedTags", this.maxDisplayedTags, params);
        SpringDocPropertiesUtils.put("showExtensions", this.showExtensions, params);
        SpringDocPropertiesUtils.put("showCommonExtensions", this.showCommonExtensions, params);
        SpringDocPropertiesUtils.put("operationsSorter", this.operationsSorter, params);
        SpringDocPropertiesUtils.put("tagsSorter", this.tagsSorter, params);
        SpringDocPropertiesUtils.put(LAYOUT_PROPERTY, this.layout, params);
        if (this.supportedSubmitMethods != null) {
            SpringDocPropertiesUtils.put("supportedSubmitMethods", this.supportedSubmitMethods.toString(), params);
        }
        SpringDocPropertiesUtils.put(OAUTH2_REDIRECT_URL_PROPERTY, this.oauth2RedirectUrl, params);
        SpringDocPropertiesUtils.put(URL_PROPERTY, this.url, params);
        this.put(URLS_PROPERTY, this.urls, params);
        SpringDocPropertiesUtils.put("urls.primaryName", this.urlsPrimaryName, params);
        SpringDocPropertiesUtils.put("tryItOutEnabled", this.tryItOutEnabled, params);
        SpringDocPropertiesUtils.put("persistAuthorization", this.persistAuthorization, params);
        SpringDocPropertiesUtils.put(FILTER_PROPERTY, this.filter, params);
        return params;
    }

    private void put(String urls, Set<AbstractSwaggerUiConfigProperties.SwaggerUrl> swaggerUrls, Map<String, Object> params) {
        Comparator<AbstractSwaggerUiConfigProperties.SwaggerUrl> swaggerUrlComparator = this.groupsOrder.isAscending() ? Comparator.comparing(AbstractSwaggerUiConfigProperties.SwaggerUrl::getName) : (h1, h2) -> h2.getName().compareTo(h1.getName());
        if (!CollectionUtils.isEmpty((Collection)(swaggerUrls = (Set)swaggerUrls.stream().sorted(swaggerUrlComparator).filter(elt -> StringUtils.isNotEmpty((CharSequence)elt.getUrl())).collect(Collectors.toCollection(LinkedHashSet::new))))) {
            params.put(urls, swaggerUrls);
        }
    }

    private boolean isSwaggerUrlDefined(String name) {
        if (!CollectionUtils.isEmpty(this.swaggerUiConfig.getUrls())) {
            return this.swaggerUiConfig.getUrls().stream().anyMatch(swaggerUrl -> name.equals(swaggerUrl.getName()) && StringUtils.isNotBlank((CharSequence)swaggerUrl.getUrl()));
        }
        return false;
    }
}

