/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.graph;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.sonar.graph.Dsm;
import org.sonar.graph.DsmCell;

public final class DsmPrinter {
    private final Writer writer;
    private final Dsm dsm;
    private static final String CELL_SEPARATOR = "| ";
    private static final String FEEDBACK_EDGE_FLAG = "*";
    private final boolean displayColumnHeaders;

    private DsmPrinter(Writer writer, Dsm dsm, boolean displayColumnHeaders) {
        this.writer = writer;
        this.dsm = dsm;
        this.displayColumnHeaders = displayColumnHeaders;
    }

    private void print() {
        try {
            if (this.displayColumnHeaders) {
                this.printColumnHeaders();
            }
            for (int y = 0; y < this.dsm.getDimension(); ++y) {
                this.printRow(y);
            }
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to print the desired DSM.", e);
        }
    }

    public static String print(Dsm dsm, boolean displayColumnHeaders) {
        StringWriter writer = new StringWriter();
        DsmPrinter.print(writer, dsm, displayColumnHeaders);
        return writer.toString();
    }

    public static String print(Dsm dsm) {
        return DsmPrinter.print(dsm, true);
    }

    public static void print(Writer writer, Dsm dsm, boolean displayColumnHeaders) {
        DsmPrinter printer = new DsmPrinter(writer, dsm, displayColumnHeaders);
        printer.print();
    }

    private void printRow(int y) throws IOException {
        this.printRowHeader(y);
        for (int x = 0; x < this.dsm.getDimension(); ++x) {
            this.printCell(y, x);
        }
        this.writer.append('\r');
    }

    private void printCell(int y, int x) throws IOException {
        DsmCell cell = this.dsm.cell(x, y);
        if (cell == null || cell.getWeight() == 0) {
            this.writer.append(" ");
        } else {
            this.writer.append("").append(String.valueOf(cell.getWeight()));
        }
        if (cell != null && cell.isFeedbackEdge()) {
            this.writer.append(FEEDBACK_EDGE_FLAG);
        } else {
            this.writer.append(' ');
        }
        this.writer.append(CELL_SEPARATOR);
    }

    private void printRowHeader(int y) throws IOException {
        this.writer.append(String.valueOf(this.dsm.getVertex(y))).append(" | ");
    }

    private void printColumnHeaders() throws IOException {
        this.writer.append("  | ");
        for (int i = 0; i < this.dsm.getDimension(); ++i) {
            this.printRowHeader(i);
        }
        this.writer.append('\r');
    }
}

