/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.io.FileUtils;
import org.sonar.api.utils.TempFolder;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class DefaultTempFolder
implements TempFolder {
    private static final Logger LOG = Loggers.get(DefaultTempFolder.class);
    private final File tempDir;
    private final boolean deleteOnExit;

    public DefaultTempFolder(File tempDir) {
        this(tempDir, false);
    }

    public DefaultTempFolder(File tempDir, boolean deleteOnExit) {
        this.tempDir = tempDir;
        this.deleteOnExit = deleteOnExit;
    }

    @Override
    public File newDir() {
        return DefaultTempFolder.createTempDir(this.tempDir.toPath()).toFile();
    }

    private static Path createTempDir(Path baseDir) {
        try {
            return Files.createTempDirectory(baseDir, null, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temp directory", e);
        }
    }

    @Override
    public File newDir(String name) {
        File dir = new File(this.tempDir, name);
        try {
            FileUtils.forceMkdir(dir);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temp directory - " + dir, e);
        }
        return dir;
    }

    @Override
    public File newFile() {
        return this.newFile(null, null);
    }

    @Override
    public File newFile(@Nullable String prefix, @Nullable String suffix) {
        return DefaultTempFolder.createTempFile(this.tempDir.toPath(), prefix, suffix).toFile();
    }

    private static Path createTempFile(Path baseDir, String prefix, String suffix) {
        try {
            return Files.createTempFile(baseDir, prefix, suffix, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temp file", e);
        }
    }

    public void clean() {
        try {
            Files.walkFileTree(this.tempDir.toPath(), DeleteRecursivelyFileVisitor.INSTANCE);
        }
        catch (IOException e) {
            LOG.trace("Failed to delete temp folder", (Object)e);
        }
    }

    public void stop() {
        if (this.deleteOnExit) {
            this.clean();
        }
    }

    private static final class DeleteRecursivelyFileVisitor
    extends SimpleFileVisitor<Path> {
        public static final DeleteRecursivelyFileVisitor INSTANCE = new DeleteRecursivelyFileVisitor();

        private DeleteRecursivelyFileVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.delete(dir);
            return FileVisitResult.CONTINUE;
        }
    }
}

