/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven.bootstrap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;
import org.sonarsource.scanner.maven.bootstrap.MavenPlugin;

public final class MavenUtils {
    public static final String GROUP_ID_APACHE_MAVEN = "org.apache.maven.plugins";
    public static final String GROUP_ID_CODEHAUS_MOJO = "org.codehaus.mojo";

    private MavenUtils() {
    }

    @CheckForNull
    public static String getSourceEncoding(MavenProject pom) {
        return pom.getProperties().getProperty("project.build.sourceEncoding");
    }

    public static String getPluginSetting(MavenProject project, String groupId, String artifactId, String optionName, @Nullable String defaultValue) {
        MavenPlugin plugin = MavenPlugin.getPlugin(project, groupId, artifactId);
        if (plugin != null) {
            return StringUtils.defaultIfEmpty((String)plugin.getParameter(optionName), (String)defaultValue);
        }
        return defaultValue;
    }

    @SafeVarargs
    public static <T> T coalesce(T ... objs) {
        for (T o : objs) {
            if (o == null) continue;
            return o;
        }
        return null;
    }

    static void putAll(Properties src, Map<String, String> dest) {
        for (String name : src.stringPropertyNames()) {
            dest.put(name, src.getProperty(name));
        }
    }

    public static String joinAsCsv(List<String> values) {
        return values.stream().map(MavenUtils::escapeCommas).collect(Collectors.joining(","));
    }

    private static String escapeCommas(String value) {
        return value.contains(",") ? "\"" + value + "\"" : value;
    }

    public static List<String> splitAsCsv(String joined) {
        ArrayList<String> collected = new ArrayList<String>();
        if (joined.indexOf(34) == -1) {
            return Arrays.asList(joined.split(","));
        }
        int start = 0;
        int end = joined.length() - 1;
        while (start < end && end < joined.length()) {
            if (joined.charAt(start) == '\"') {
                end = joined.indexOf(34, start + 1);
                String value = joined.substring(start + 1, end);
                collected.add(value);
                int nextComma = joined.indexOf(",", end);
                if (nextComma == -1) break;
                start = nextComma + 1;
            } else {
                int nextComma = joined.indexOf(",", start);
                end = nextComma == -1 ? joined.length() : nextComma;
                String value = joined.substring(start, end);
                collected.add(value);
                start = end + 1;
            }
            end = start + 1;
        }
        return collected;
    }
}

