/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.api.mailer.config.EmailGovernance;
import org.simplejavamail.converter.internal.mimemessage.ImmutableDelegatingSMTPMessage;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageHelper;
import org.simplejavamail.internal.moduleloader.ModuleLoader;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;

public abstract class SpecializedMimeMessageProducer {
    abstract boolean compatibleWithEmail(@NotNull Email var1);

    final MimeMessage populateMimeMessage(final Email email, EmailGovernance emailGovernance, @NotNull Session session) throws MessagingException, UnsupportedEncodingException {
        Recipient bountToRecipient;
        MiscUtil.checkArgumentNotEmpty((Object)email, (String)"email is missing");
        MiscUtil.checkArgumentNotEmpty((Object)session, (String)"session is needed, it cannot be attached later");
        Object message = new MimeMessage(session){

            protected void updateMessageID() throws MessagingException {
                if (MiscUtil.valueNullOrEmpty((Object)email.getId())) {
                    super.updateMessageID();
                } else {
                    this.setHeader("Message-ID", email.getId());
                }
            }

            public String toString() {
                try {
                    return "MimeMessage<id:" + super.getMessageID() + ", subject:" + super.getSubject() + ">";
                }
                catch (MessagingException e) {
                    throw new IllegalStateException("should not reach here");
                }
            }
        };
        MimeMessageHelper.setSubject(email, emailGovernance, message);
        MimeMessageHelper.setFrom(email, emailGovernance, message);
        MimeMessageHelper.setReplyTo(email, emailGovernance, (Message)message);
        MimeMessageHelper.setRecipients(email, emailGovernance, (Message)message);
        this.populateMimeMessageMultipartStructure((MimeMessage)message, email, emailGovernance);
        MimeMessageHelper.setHeaders(email, emailGovernance, (Message)message);
        message.setSentDate(Optional.ofNullable(email.getSentDate()).orElse(new Date()));
        if (!(MiscUtil.valueNullOrEmpty((Object)email.getPkcs12ConfigForSmimeSigning()) && MiscUtil.valueNullOrEmpty((Object)emailGovernance.getPkcs12ConfigForSmimeSigning()) && MiscUtil.valueNullOrEmpty((Object)email.getX509CertificateForSmimeEncryption()))) {
            message = ModuleLoader.loadSmimeModule().signAndOrEncryptEmail(session, message, email, emailGovernance.getPkcs12ConfigForSmimeSigning());
        }
        if (!MiscUtil.valueNullOrEmpty((Object)email.getDkimConfig())) {
            message = ModuleLoader.loadDKIMModule().signMessageWithDKIM(message, email.getDkimConfig(), (Recipient)Preconditions.checkNonEmptyArgument((Object)email.getFromRecipient(), (String)"fromRecipient"));
        }
        if ((bountToRecipient = (Recipient)MiscUtil.orOther((Object)email, (Object)emailGovernance.getEmailDefaults(), (Object)emailGovernance.getEmailOverrides(), Email::getBounceToRecipient)) != null) {
            message = new ImmutableDelegatingSMTPMessage((MimeMessage)message, bountToRecipient.getAddress());
        }
        return message;
    }

    abstract void populateMimeMessageMultipartStructure(MimeMessage var1, Email var2, EmailGovernance var3) throws MessagingException;

    static boolean emailContainsMixedContent(@NotNull Email email) {
        return !email.getAttachments().isEmpty() || email.getEmailToForward() != null;
    }

    static boolean emailContainsRelatedContent(@NotNull Email email) {
        return !email.getEmbeddedImages().isEmpty();
    }

    static boolean emailContainsAlternativeContent(@NotNull Email email) {
        return (email.getPlainText() != null ? 1 : 0) + (email.getHTMLText() != null ? 1 : 0) + (email.getCalendarText() != null ? 1 : 0) > 1;
    }
}

