/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.simpleflatmapper.converter.ContextFactory;
import org.simpleflatmapper.converter.ContextFactoryBuilder;
import org.simpleflatmapper.converter.ContextualConverter;
import org.simpleflatmapper.converter.ConverterService;
import org.simpleflatmapper.converter.DefaultContextFactoryBuilder;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.MapPropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.TypeHelper;

public class MapClassMeta<M extends Map<K, V>, K, V>
implements ClassMeta<M> {
    private final ReflectionService reflectionService;
    private final ContextualConverter<? super CharSequence, ? extends K> keyConverter;
    private final ContextFactory keyContextFactory;
    private final ClassMeta<V> valueClassMeta;
    private final Type type;
    private final Constructor<?> constructor;

    public MapClassMeta(Type type, Type keyType, Type valueType, ReflectionService reflectionService) {
        this.type = type;
        DefaultContextFactoryBuilder contextFactoryBuilder = new DefaultContextFactoryBuilder();
        this.keyConverter = ConverterService.getInstance().findConverter(CharSequence.class, keyType, (ContextFactoryBuilder)contextFactoryBuilder, new Object[0]);
        this.keyContextFactory = contextFactoryBuilder.build();
        this.reflectionService = reflectionService;
        this.valueClassMeta = reflectionService.getClassMeta(valueType);
        this.constructor = this.getConstructor(type);
    }

    public MapClassMeta(ReflectionService reflectionService, ContextualConverter<? super CharSequence, ? extends K> keyConverter, ContextFactory keyContextFactory, ClassMeta<V> valueClassMeta, Type type, Constructor<?> constructor) {
        this.reflectionService = reflectionService;
        this.keyConverter = keyConverter;
        this.keyContextFactory = keyContextFactory;
        this.valueClassMeta = valueClassMeta;
        this.type = type;
        this.constructor = constructor;
    }

    @Override
    public ClassMeta<M> withReflectionService(ReflectionService reflectionService) {
        return new MapClassMeta(reflectionService, this.keyConverter, this.keyContextFactory, reflectionService.getClassMeta(this.valueClassMeta.getType()), this.type, this.constructor);
    }

    private Constructor<?> getConstructor(Type type) {
        Class<?> implClass = this.findMapImpl(type);
        try {
            return implClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No empty constructor for " + implClass);
        }
    }

    private Class<?> findMapImpl(Type type) {
        Class clazz = TypeHelper.toClass((Type)type);
        if (clazz.isInterface()) {
            if (Map.class.equals((Object)clazz)) {
                return HashMap.class;
            }
            if (ConcurrentMap.class.equals((Object)clazz)) {
                return ConcurrentHashMap.class;
            }
        } else if (!Modifier.isAbstract(clazz.getModifiers())) {
            return clazz;
        }
        throw new IllegalArgumentException("No known Map impl for " + type);
    }

    @Override
    public ReflectionService getReflectionService() {
        return this.reflectionService;
    }

    @Override
    public PropertyFinder<M> newPropertyFinder() {
        return new MapPropertyFinder(this, this.valueClassMeta, this.keyConverter, this.keyContextFactory, this.reflectionService.selfScoreFullName());
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public List<InstantiatorDefinition> getInstantiatorDefinitions() {
        return Arrays.asList(new ExecutableInstantiatorDefinition(this.constructor, new Parameter[0]));
    }

    @Override
    public void forEachProperties(Consumer<? super PropertyMeta<M, ?>> consumer) {
        throw new UnsupportedOperationException("Cannot list properties as non static");
    }

    @Override
    public int getNumberOfProperties() {
        return 10000;
    }

    @Override
    public boolean needTransformer() {
        return false;
    }
}

