package org.sharengo.wikitty.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;

/**
 * Interface for BusinessEntity, interfaces are needed for multiple inheritance
 *
 * @author poussin
 */
public class BusinessEntityInterfaceGenerator extends WikengoCommonGenerator {
	
	private static final Log log = LogFactory.getLog(BusinessEntityInterfaceGenerator.class);

    protected String EXT_NAME;

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = clazz.getQualifiedName();
        log.info( "Filename for " + clazz.getName() + " is " +  fqn.replace('.', File.separatorChar) + ".java");
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz)
            throws IOException {
        if (!EugengoUtils.isBusinessEntity(clazz)) {
        	log.info( clazz.getName() + " is not a business entity");
            return;
        }

        log.info("Generate Business entity " + clazz.getName() + "... ");
        generateCopyright(output);

        EXT_NAME = "EXT_" + clazz.getName().toUpperCase();
        String packageName = clazz.getPackageName();
        String name = clazz.getName();
output.write("package "+packageName+";\n");
output.write("\n");
output.write("");
        ObjectModelClass superClass = findSuperClass(clazz);

        clearImports();
        addImport(superClass);
        addImport("org.sharengo.wikitty.BusinessEntity");

        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (EugengoUtils.isBusinessEntity(parent)) {
                addImport(parent);
            }
        }
        lookForAttributeImports(clazz);
        generateImports(output, packageName);

        String extendsString = "extends " + getType("org.sharengo.wikitty.BusinessEntity");
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (EugengoUtils.isBusinessEntity(parent)) {
                extendsString += ", " + getType(parent.getName());
            }
        }

output.write("public interface "+name+" "+extendsString+" {\n");
output.write("\n");
output.write("    static final public String "+EXT_NAME+" = \""+clazz.getName()+"\";\n");
output.write("\n");
output.write("");
        generateFieldNameConstant(output, clazz);

        generateStaticAttributes(output, clazz);

        generateAttributeAccessMethod(output, clazz);

output.write("\n");
output.write("} //"+name+"\n");
output.write("");

    }

    // Utilitarian methods
        private void generateFieldNameConstant(Writer output,
            ObjectModelClass clazz) throws IOException {
    	for (ObjectModelAttribute attr : clazz.getAttributes()) {
    		if (attr.isNavigable() && !attr.isStatic() &&
                    (attr.getStereotypes() == null || attr.getStereotypes().isEmpty())) {
output.write("    static final public String FIELD_"+attr.getName().toUpperCase()+" = \""+attr.getName()+"\";\n");
output.write("    static final public String FQ_FIELD_"+attr.getName().toUpperCase()+" = "+EXT_NAME+" + \"."+attr.getName()+"\";\n");
output.write("");
    		}
    	}
    }

    public void generateAttributeAccessMethod(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (attr.isNavigable() && !attr.isStatic()
                    && (attr.getStereotypes() == null || attr.getStereotypes().isEmpty())) {
        		if ((attr.getMaxMultiplicity() != 0 && attr.getMaxMultiplicity() != 1)) {
        			//TODO ymartel 20090812: when dataType "List", "Set" or "Collection" in model, must be here!
        			generateCollectionAttributeAccessors(output, attr);
        		} else {
        			generateWikittyAttributeAccessors(output, attr);
        		}
            }
        }
    }
    
    protected void generateWikittyAttributeAccessors(Writer output, 
    		ObjectModelAttribute attr) throws IOException {
    	String attrType = computeType(attr);
    	if (EugengoUtils.notEmpty(attrType)) {
    		attrType = getType(attrType, true);
    	} else {
    		return;
    	}

        String attrName = attr.getName();
    	String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter(attrName);

output.write("\n");
output.write("    public void set"+attrNameCapitalized+"("+attrType+" "+attrName+");\n");
output.write("    public "+attrType+" get"+attrNameCapitalized+"();\n");
output.write("\n");
output.write("");
    }

    protected void generateCollectionAttributeAccessors(Writer output, 
    		ObjectModelAttribute attr) throws IOException {
    	String attrType = computeType(attr);
    	if (EugengoUtils.notEmpty(attrType)) {
    		attrType = getType(attrType, true);
    	} else {
    		return;
    	}

        // get collection element type for add and remove method arguement type
        String elementType = getType(attr.getType(), true);

    	String attrName = attr.getName();
    	String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter(attrName);
output.write("    public "+attrType+" get"+attrNameCapitalized+"();\n");
output.write("    public void add"+attrNameCapitalized+"("+elementType+" element);\n");
output.write("    public void remove"+attrNameCapitalized+"("+elementType+" element);\n");
output.write("    public void clear"+attrNameCapitalized+"();\n");
output.write("\n");
output.write("");
    }
    
}
