/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Color {
    private final short red;
    private final short green;
    private final short blue;
    private final float alpha;
    private static final Converter[] CONVERTERS = new Converter[]{new RgbaConverter(), new HexConverter(), new Hex3Converter(), new RgbConverter(), new RgbPctConverter(), new RgbaPctConverter(), new HslConverter(), new HslaConverter()};

    public static Color fromString(String value) {
        for (Converter converter : CONVERTERS) {
            Color color = converter.getColor(value);
            if (color == null) continue;
            return color;
        }
        throw new IllegalArgumentException(String.format("Did not know how to convert %s into color", value));
    }

    private Color(short red, short green, short blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public String asRgb() {
        return String.format("rgb(%d, %d, %d)", this.red, this.green, this.blue);
    }

    public String asRgba() {
        String formatSpec = this.alpha == 1.0f ? "rgba(%d, %d, %d, %.0f)" : "rgba(%d, %d, %d, %.1f)";
        return String.format(formatSpec, this.red, this.green, this.blue, Float.valueOf(this.alpha));
    }

    public String asHex() {
        return String.format("#%02x%02x%02x", this.red, this.green, this.blue);
    }

    private static class HslaConverter
    extends HslConverter {
        private static final Pattern HSLA_PATTERN = Pattern.compile("^\\s*hsla\\(\\s*(0|[1-9]\\d{0,2})\\s*,\\s*(0|[1-9]\\d{0,2})\\%\\s*,\\s*(0|[1-9]\\d{0,2})\\%\\s*,\\s*(0|1|0\\.\\d*)\\s*\\)\\s*$");

        private HslaConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return HSLA_PATTERN;
        }
    }

    private static class HslConverter
    extends Converter {
        private static final Pattern HSL_PATTERN = Pattern.compile("^\\s*hsl\\(\\s*(0|[1-9]\\d{0,2})\\s*,\\s*(0|[1-9]\\d{0,2})\\%\\s*,\\s*(0|[1-9]\\d{0,2})\\%\\s*\\)\\s*$");

        private HslConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return HSL_PATTERN;
        }

        @Override
        protected int getRadix() {
            return 10;
        }

        @Override
        protected Color createColor(Matcher matcher, float a) {
            float b;
            float g;
            float r;
            float h = Float.parseFloat(matcher.group(1)) / 360.0f;
            float s = Float.parseFloat(matcher.group(2)) / 100.0f;
            float l = Float.parseFloat(matcher.group(3)) / 100.0f;
            if (s == 0.0f) {
                g = r = l;
                b = r;
            } else {
                float l2 = (double)l < 0.5 ? l * (1.0f + s) : l + s - l * s;
                float l1 = 2.0f * l - l2;
                r = this.hueToRgb(l1, l2, h + 0.33333334f);
                g = this.hueToRgb(l1, l2, h);
                b = this.hueToRgb(l1, l2, h - 0.33333334f);
            }
            return new Color((short)(r * 256.0f), (short)(g * 256.0f), (short)(b * 256.0f), a);
        }

        private float hueToRgb(float l1, float l2, float h) {
            if (h < 0.0f) {
                h += 1.0f;
            }
            if (h > 1.0f) {
                h -= 1.0f;
            }
            if (h < 0.16666667f) {
                return l1 + (l2 - l1) * 6.0f * h;
            }
            if (h < 0.5f) {
                return l2;
            }
            if (h < 0.6666667f) {
                return l1 + (l2 - l1) * (0.6666667f - h) * 6.0f;
            }
            return l1;
        }
    }

    private static class Hex3Converter
    extends Converter {
        private static final Pattern HEX3_PATTERN = Pattern.compile("#(\\p{XDigit}{1})(\\p{XDigit}{1})(\\p{XDigit}{1})");

        private Hex3Converter() {
        }

        @Override
        protected Pattern getPattern() {
            return HEX3_PATTERN;
        }

        @Override
        protected int getRadix() {
            return 16;
        }

        @Override
        protected short fromMatchGroup(Matcher matcher, int index) {
            return Short.parseShort(matcher.group(index) + matcher.group(index), this.getRadix());
        }
    }

    private static class HexConverter
    extends Converter {
        private static final Pattern HEX_PATTERN = Pattern.compile("#(\\p{XDigit}{2})(\\p{XDigit}{2})(\\p{XDigit}{2})");

        private HexConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return HEX_PATTERN;
        }

        @Override
        protected int getRadix() {
            return 16;
        }
    }

    private static class RgbaPctConverter
    extends RgbPctConverter {
        private static final Pattern RGBAPCT_PATTERN = Pattern.compile("^\\s*rgba\\(\\s*(\\d{1,3}|\\d{1,2}\\.\\d*)%\\s*,\\s*(\\d{1,3}|\\d{1,2}\\.\\d*)%\\s*,\\s*(\\d{1,3}|\\d{1,2}\\.\\d*)%\\s*,\\s*(0|1|0\\.\\d*)\\s*\\)\\s*$");

        private RgbaPctConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return RGBAPCT_PATTERN;
        }
    }

    private static class RgbaConverter
    extends RgbConverter {
        private static final Pattern RGBA_PATTERN = Pattern.compile("^\\s*rgba\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(0|1|0\\.\\d*)\\s*\\)\\s*$");

        private RgbaConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return RGBA_PATTERN;
        }
    }

    private static class RgbPctConverter
    extends Converter {
        private static final Pattern RGBPCT_PATTERN = Pattern.compile("^\\s*rgb\\(\\s*(\\d{1,3}|\\d{1,2}\\.\\d*)%\\s*,\\s*(\\d{1,3}|\\d{1,2}\\.\\d*)%\\s*,\\s*(\\d{1,3}|\\d{1,2}\\.\\d*)%\\s*\\)\\s*$");

        private RgbPctConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return RGBPCT_PATTERN;
        }

        @Override
        protected int getRadix() {
            return 10;
        }

        @Override
        protected short fromMatchGroup(Matcher matcher, int index) {
            float n = Float.parseFloat(matcher.group(index)) / 100.0f * 255.0f;
            return (short)n;
        }
    }

    private static class RgbConverter
    extends Converter {
        private static final Pattern RGB_PATTERN = Pattern.compile("^\\s*rgb\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*\\)\\s*$");

        private RgbConverter() {
        }

        @Override
        protected Pattern getPattern() {
            return RGB_PATTERN;
        }

        @Override
        protected int getRadix() {
            return 10;
        }
    }

    private static abstract class Converter {
        private Converter() {
        }

        public Color getColor(String value) {
            Matcher matcher = this.getPattern().matcher(value);
            if (matcher.find()) {
                float a = 1.0f;
                if (matcher.groupCount() == 4) {
                    a = Float.parseFloat(matcher.group(4));
                }
                return this.createColor(matcher, a);
            }
            return null;
        }

        protected Color createColor(Matcher matcher, float a) {
            return new Color(this.fromMatchGroup(matcher, 1), this.fromMatchGroup(matcher, 2), this.fromMatchGroup(matcher, 3), a);
        }

        protected short fromMatchGroup(Matcher matcher, int index) {
            return Short.parseShort(matcher.group(index), this.getRadix());
        }

        protected abstract Pattern getPattern();

        protected abstract int getRadix();
    }
}

