/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.rest.RestishHandler;
import org.openqa.selenium.remote.server.rest.ResultType;
import org.openqa.selenium.server.log.LoggingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewSession
implements RestishHandler,
JsonParametersAware {
    private volatile DriverSessions allSessions;
    private volatile Capabilities desiredCapabilities;
    private volatile SessionId sessionId;
    private final Response response;

    public NewSession(DriverSessions allSession) {
        this.allSessions = allSession;
        this.response = new Response();
    }

    public Capabilities getCapabilities() {
        return this.desiredCapabilities;
    }

    public Response getResponse() {
        return this.response;
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.desiredCapabilities = new DesiredCapabilities((Map)allParameters.get("desiredCapabilities"));
    }

    @Override
    public ResultType handle() throws Exception {
        this.sessionId = this.allSessions.newSession((Capabilities)(this.desiredCapabilities != null ? this.desiredCapabilities : new DesiredCapabilities()));
        this.response.setSessionId(this.sessionId.toString());
        this.response.setValue((Object)this.allSessions.get(this.sessionId).getCapabilities().asMap());
        LoggingManager.perSessionLogHandler().attachToCurrentThread(this.sessionId.toString());
        return ResultType.SUCCESS;
    }

    public String getSessionId() {
        return this.sessionId.toString();
    }

    public String toString() {
        HashMap capabilities = Maps.newHashMap();
        if (this.desiredCapabilities != null) {
            for (Map.Entry entry : this.desiredCapabilities.asMap().entrySet()) {
                String value = String.valueOf(entry.getValue());
                if (value.length() > 32) {
                    value = value.substring(0, 29) + "...";
                }
                capabilities.put(entry.getKey(), value);
            }
        }
        return String.format("[new session: %s]", capabilities);
    }
}

