/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.Logs;
import org.openqa.selenium.remote.ExecuteMethod;

@Beta
public class RemoteLogs
implements Logs {
    private static final String LEVEL = "level";
    private static final String TIMESTAMP = "timestamp";
    private static final String MESSAGE = "message";
    protected ExecuteMethod executeMethod;
    private static final String TYPE_KEY = "type";

    public RemoteLogs(ExecuteMethod executeMethod) {
        this.executeMethod = executeMethod;
    }

    public LogEntries get(String logType) {
        Object raw = this.executeMethod.execute("getLogs", (Map<String, ?>)ImmutableMap.of((Object)TYPE_KEY, (Object)logType));
        if (raw instanceof List) {
            List rawList = (List)raw;
            ArrayList entries = Lists.newArrayListWithCapacity((int)rawList.size());
            for (Map obj : rawList) {
                entries.add(new LogEntry(((Long)obj.get(LEVEL)).intValue(), ((Long)obj.get(TIMESTAMP)).longValue(), (String)obj.get(MESSAGE)));
            }
            return new LogEntries((List)entries);
        }
        if (raw instanceof String) {
            Pattern pattern = Pattern.compile("\\{.*?\"\\}\n");
            Matcher matcher = pattern.matcher((String)raw);
            ArrayList entries = Lists.newArrayList();
            while (matcher.find()) {
                try {
                    JSONObject jsonObject = new JSONObject(matcher.group());
                    entries.add(new LogEntry(((Integer)jsonObject.get(LEVEL)).intValue(), ((Long)jsonObject.get(TIMESTAMP)).longValue(), (String)jsonObject.get(MESSAGE)));
                }
                catch (JSONException e) {
                    throw new WebDriverException("Failed to parse logs. Raw result: " + raw, (Throwable)e);
                }
            }
            return new LogEntries((List)entries);
        }
        throw new WebDriverException("Don't know how to parse log results: " + raw.toString());
    }
}

