/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import com.google.common.base.Supplier;
import com.thoughtworks.selenium.SeleniumException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SuppliesWebDriver
implements Supplier<WebDriver> {
    private final Capabilities capabilities;

    SuppliesWebDriver(Capabilities caps) {
        this.capabilities = caps;
    }

    public WebDriver get() {
        String browser = this.capabilities.getBrowserName();
        if (DesiredCapabilities.firefox().getBrowserName().equals(browser)) {
            return new FirefoxDriver();
        }
        if (DesiredCapabilities.internetExplorer().getBrowserName().equals(browser)) {
            return new InternetExplorerDriver();
        }
        if (DesiredCapabilities.chrome().getBrowserName().equals(browser)) {
            return new ChromeDriver();
        }
        throw new SeleniumException("Unable to determine which driver to use: " + this.capabilities);
    }
}

