/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.openqa.selenium.logging.LogEntry;

public class LoggingHandler
extends Handler {
    private static final int MAX_RECORDS = 1000;
    private LinkedList<LogEntry> records = Lists.newLinkedList();
    private static final LoggingHandler instance = new LoggingHandler();

    private LoggingHandler() {
    }

    public static LoggingHandler getInstance() {
        return instance;
    }

    public synchronized List<LogEntry> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        if (this.isLoggable(logRecord)) {
            if (this.records.size() > 1000) {
                this.records.remove();
            }
            this.records.add(new LogEntry(logRecord.getLevel(), logRecord.getMillis(), logRecord.getLoggerName() + " " + logRecord.getSourceClassName() + "." + logRecord.getSourceMethodName() + " " + logRecord.getMessage()));
        }
    }

    public void attachTo(Logger logger, Level level) {
        Handler[] handlers;
        for (Handler handler : handlers = logger.getHandlers()) {
            if (handler != this) continue;
            return;
        }
        this.setLevel(level);
        logger.addHandler(this);
    }

    @Override
    public void flush() {
    }

    @Override
    public synchronized void close() throws SecurityException {
        this.records.clear();
    }
}

