/*
 * Decompiled with CFR 0.152.
 */
package org_scala_tools_maven_cs;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.yaml.snakeyaml.Yaml;
import org_scala_tools_maven_cs.ScalaCSMojoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalaCSInitMojo
extends ScalaCSMojoSupport {
    protected File outputDir;
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    protected File sourceDir;
    protected File testOutputDir;
    protected File testSourceDir;
    protected boolean dumpYaml;
    protected boolean compileAfterInit;

    @Override
    protected CharSequence doRequest() throws Exception {
        String yaml = ((Object)this.toYaml(this.project)).toString();
        if (this.dumpYaml) {
            new File(this.project.getBuild().getDirectory()).mkdirs();
            FileUtils.fileWrite((String)(this.project.getBuild().getDirectory() + "/project.yaml"), (String)"UTF-8", (String)yaml);
        }
        StringBuilder back = new StringBuilder();
        back.append(this.scs.sendRequestCreateOrUpdate(yaml));
        if (this.compileAfterInit) {
            back.append(this.scs.sendRequestCompile(this.project.getArtifactId() + "-" + this.project.getVersion(), true, true));
        }
        return back;
    }

    private CharSequence toYaml(MavenProject project) throws Exception {
        HashMap<String, Object> dataCompile = new HashMap<String, Object>();
        dataCompile.put("name", project.getArtifactId() + "-" + project.getVersion() + "/main");
        dataCompile.put("sourceDirs", this.getSourceDirectories());
        if (this.includes != null) {
            dataCompile.put("includes", new ArrayList<String>(this.includes));
        }
        if (this.excludes != null) {
            dataCompile.put("excludes", new ArrayList<String>(this.excludes));
        }
        dataCompile.put("targetDir", this.outputDir.getCanonicalPath());
        dataCompile.put("classpath", project.getCompileClasspathElements());
        if (this.args != null) {
            dataCompile.put("args", this.args);
        }
        dataCompile.put("exported", new File(this.localRepo.getBasedir(), this.localRepo.pathOf(project.getArtifact())).getCanonicalPath());
        HashMap<String, Object> dataTest = new HashMap<String, Object>();
        dataTest.put("name", project.getArtifactId() + "-" + project.getVersion() + "/test");
        dataTest.put("sourceDirs", project.getTestCompileSourceRoots());
        if (this.includes != null) {
            dataTest.put("includes", new ArrayList<String>(this.includes));
        }
        if (this.excludes != null) {
            dataTest.put("excludes", new ArrayList<String>(this.excludes));
        }
        dataTest.put("targetDir", this.testOutputDir.getCanonicalPath());
        dataTest.put("classpath", project.getTestClasspathElements());
        if (this.args != null) {
            dataTest.put("args", this.args);
        }
        Yaml yaml = new Yaml();
        LinkedList<HashMap<String, Object>> prjs = new LinkedList<HashMap<String, Object>>();
        prjs.add(dataCompile);
        prjs.add(dataTest);
        return yaml.dumpAll(prjs.iterator());
    }

    protected List<String> getSourceDirectories() throws Exception {
        String scalaSourceDir;
        List sources = this.project.getCompileSourceRoots();
        if (!sources.contains(scalaSourceDir = this.sourceDir.getCanonicalPath())) {
            sources.add(scalaSourceDir);
        }
        return sources;
    }
}

