/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy.specimpl;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.resteasy.util.Encode;
import org.resteasy.util.PathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriBuilderImpl
extends UriBuilder {
    private String host;
    private String scheme;
    private int port = -1;
    private boolean encode = true;
    private String userInfo;
    private String path;
    private String matrix;
    private String query;
    private String fragment;

    public UriBuilder clone() {
        UriBuilderImpl impl = new UriBuilderImpl();
        impl.host = this.host;
        impl.scheme = this.scheme;
        impl.port = this.port;
        impl.encode = this.encode;
        impl.userInfo = this.userInfo;
        impl.path = this.path;
        impl.matrix = this.matrix;
        impl.query = this.query;
        impl.fragment = this.fragment;
        return impl;
    }

    public UriBuilder encode(boolean enable) {
        this.encode = enable;
        return this;
    }

    public UriBuilder uri(URI uri) throws IllegalArgumentException {
        int idx;
        if (uri.getHost() != null) {
            this.host = uri.getHost();
        }
        if (uri.getScheme() != null) {
            this.scheme = uri.getScheme();
        }
        if (uri.getHost() != null) {
            this.port = uri.getPort();
        }
        if (uri.getUserInfo() != null) {
            this.userInfo = uri.getRawUserInfo();
        }
        if (uri.getPath() != null && !uri.getPath().equals("")) {
            this.path = uri.getRawPath();
        }
        if (this.path != null && (idx = this.path.indexOf(59)) > -1) {
            this.matrix = this.path.substring(idx);
            this.path = this.path.substring(0, idx);
        }
        if (uri.getFragment() != null) {
            this.fragment = uri.getRawFragment();
        }
        if (uri.getQuery() != null) {
            this.query = uri.getRawQuery();
        }
        return this;
    }

    public UriBuilder scheme(String scheme) throws IllegalArgumentException {
        this.scheme = scheme;
        return this;
    }

    public UriBuilder schemeSpecificPart(String ssp) throws IllegalArgumentException {
        StringBuffer uriStr = new StringBuffer();
        if (this.scheme != null) {
            uriStr.append(this.scheme).append(":");
        }
        uriStr.append(ssp);
        if (this.fragment != null) {
            uriStr.append("#").append(this.fragment);
        }
        return this.uri(URI.create(uriStr.toString()));
    }

    public UriBuilder userInfo(String ui) throws IllegalArgumentException {
        this.userInfo = ui;
        return this;
    }

    public UriBuilder host(String host) throws IllegalArgumentException {
        this.host = host;
        return this;
    }

    public UriBuilder port(int port) throws IllegalArgumentException {
        this.port = port;
        return this;
    }

    public UriBuilder replacePath(String ... segments) throws IllegalArgumentException {
        this.path = UriBuilderImpl.paths(this.isEncode(), null, segments);
        return this;
    }

    protected static String paths(boolean encode, String basePath, String ... segments) {
        String path = basePath;
        if (path == null) {
            path = "";
        }
        for (String segment : segments) {
            if ("".equals(segment)) continue;
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (segment.equals("/")) continue;
            if (segment.startsWith("/")) {
                segment = segment.substring(1);
            }
            if (encode) {
                segment = Encode.encodePath(segment);
            }
            path = path + segment;
        }
        return path;
    }

    public UriBuilder path(String ... segments) throws IllegalArgumentException {
        this.path = UriBuilderImpl.paths(this.isEncode(), this.path, segments);
        return this;
    }

    public UriBuilder path(Class resource) throws IllegalArgumentException {
        Path ann = resource.getAnnotation(Path.class);
        if (ann != null) {
            String[] segments = new String[]{ann.value()};
            this.path = UriBuilderImpl.paths(ann.encode(), this.path, segments);
        }
        return this;
    }

    public UriBuilder path(Class resource, String method) throws IllegalArgumentException {
        for (Method m : resource.getMethods()) {
            if (!m.getName().equals(method)) continue;
            return this.path(m);
        }
        return this;
    }

    public UriBuilder path(Method ... methods) throws IllegalArgumentException {
        for (Method method : methods) {
            Path ann = method.getAnnotation(Path.class);
            if (ann == null) continue;
            String[] segments = new String[]{ann.value()};
            this.path = UriBuilderImpl.paths(ann.encode(), this.path, segments);
        }
        return this;
    }

    public UriBuilder replaceMatrixParams(String matrix) throws IllegalArgumentException {
        this.matrix = matrix;
        return this;
    }

    public UriBuilder matrixParam(String name, String value) throws IllegalArgumentException {
        if (this.matrix == null) {
            this.matrix = "";
        }
        StringBuilder tmp = new StringBuilder(this.matrix);
        tmp.append(";").append(name).append("=").append(value);
        this.matrix = tmp.toString();
        return this;
    }

    public UriBuilder replaceQueryParams(String query) throws IllegalArgumentException {
        this.query = query;
        return this;
    }

    protected String encodeString(String value) {
        if (!this.isEncode()) {
            return value;
        }
        return Encode.encodeSegment(value);
    }

    public UriBuilder queryParam(String name, String value) throws IllegalArgumentException {
        this.query = this.query == null ? this.encodeString(name) + "=" + this.encodeString(value) : this.query + "&" + this.encodeString(name) + "=" + this.encodeString(value);
        return this;
    }

    public UriBuilder fragment(String fragment) throws IllegalArgumentException {
        this.fragment = this.encodeString(fragment);
        return this;
    }

    public UriBuilder uriParam(String name, String value) throws IllegalArgumentException {
        if (this.path == null) {
            return this;
        }
        if (this.path.startsWith("/")) {
            this.path = this.path.substring(1);
        }
        String[] paths = this.path.split("/");
        int i = 0;
        for (String p : paths) {
            String uriParamName;
            Matcher matcher = PathHelper.URI_TEMPLATE_PATTERN.matcher(p);
            if (matcher.matches() && (uriParamName = matcher.group(2)).equals(name)) {
                paths[i] = value;
                break;
            }
            ++i;
        }
        this.path = null;
        this.path(paths);
        return this;
    }

    public URI build() throws UriBuilderException {
        return this.build(this.path);
    }

    protected URI build(String tmpPath) throws UriBuilderException {
        if (this.matrix != null) {
            if (tmpPath == null) {
                tmpPath = "";
            }
            if (!this.matrix.startsWith(";")) {
                tmpPath = tmpPath + ";";
            }
            tmpPath = tmpPath + this.matrix;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.scheme != null) {
            buffer.append(this.scheme).append("://");
        }
        if (this.userInfo != null) {
            buffer.append(this.userInfo).append("@");
        }
        if (this.host != null) {
            buffer.append(this.host);
        }
        if (this.port != -1 && this.port != 80) {
            buffer.append(":").append(Integer.toString(this.port));
        }
        if (tmpPath != null) {
            buffer.append(tmpPath);
        }
        if (this.query != null) {
            buffer.append("?").append(this.query);
        }
        if (this.fragment != null) {
            buffer.append("#").append(this.fragment);
        }
        String buf = buffer.toString();
        try {
            return URI.create(buf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create URI: " + buf, e);
        }
    }

    private String encodeSegment(String value) {
        if (this.isEncode()) {
            return Encode.encodeSegment(value);
        }
        return value;
    }

    public URI build(Map<String, Object> values) throws IllegalArgumentException, UriBuilderException {
        if (values.size() <= 0 || this.path == null) {
            return this.build();
        }
        if (this.path.startsWith("/")) {
            this.path = this.path.substring(1);
        }
        String[] paths = this.path.split("/");
        int i = 0;
        for (String p : paths) {
            Matcher matcher = PathHelper.URI_TEMPLATE_PATTERN.matcher(p);
            if (matcher.matches()) {
                String uriParamName = matcher.group(2);
                Object value = values.get(uriParamName);
                if (value == null) {
                    throw new IllegalArgumentException("uri parameter {" + uriParamName + "} does not exist as a value");
                }
                paths[i] = this.encodeSegment(value.toString());
            }
            ++i;
        }
        String tmpPath = UriBuilderImpl.paths(this.isEncode(), null, paths);
        return this.build(tmpPath);
    }

    protected List<String> getUriParamNamesInDeclarationOrder() {
        String[] paths;
        ArrayList<String> params = new ArrayList<String>();
        if (this.path == null) {
            return params;
        }
        if (this.path.startsWith("/")) {
            this.path = this.path.substring(1);
        }
        for (String p : paths = this.path.split("/")) {
            Matcher matcher = PathHelper.URI_TEMPLATE_PATTERN.matcher(p);
            if (!matcher.matches()) continue;
            params.add(matcher.group(2));
        }
        return params;
    }

    public URI build(Object ... values) throws IllegalArgumentException, UriBuilderException {
        if (values.length <= 0) {
            return this.build();
        }
        List<String> params = this.getUriParamNamesInDeclarationOrder();
        if (params.size() == 0) {
            throw new IllegalArgumentException("There are no @PathParams");
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        int i = 0;
        for (Object val : values) {
            String pathParam;
            if (pathParams.containsKey(pathParam = params.get(i++))) {
                throw new IllegalArgumentException("More values passed in than there are @PathParams");
            }
            pathParams.put(pathParam, val.toString());
        }
        return this.build(pathParams);
    }

    public String getHost() {
        return this.host;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isEncode() {
        return this.encode;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getPath() {
        return this.path;
    }

    public String getMatrix() {
        return this.matrix;
    }

    public String getQuery() {
        return this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public void setPath(String path) {
        this.path = this.isEncode() && path != null ? Encode.encodePath(path) : path;
    }

    public UriBuilder extension(String extension) {
        if (this.path != null) {
            int index;
            int lastPath = this.path.lastIndexOf(47);
            if (lastPath < 0) {
                lastPath = 0;
            }
            if ((index = this.path.indexOf(46, lastPath)) > -1) {
                this.path = this.path.substring(0, index);
            }
        }
        if (extension == null) {
            return this;
        }
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        if (this.isEncode()) {
            extension = Encode.encodeSegment(extension);
        }
        if (this.path == null) {
            this.path = "." + extension;
        } else {
            if (!this.path.endsWith(".")) {
                this.path = this.path + ".";
            }
            this.path = this.path + extension;
        }
        return this;
    }

    public static void main(String[] args) throws Exception {
        String path = "/foo.txt/hello.html";
        path = UriBuilderImpl.removeDot(path);
        System.out.println(path);
        path = "foo/bar";
        path = UriBuilderImpl.removeDot(path);
        System.out.println(path);
    }

    private static String removeDot(String path) {
        int index;
        int lastPath = path.lastIndexOf(47);
        if (lastPath < 0) {
            lastPath = 0;
        }
        if ((index = path.indexOf(46, lastPath)) > -1) {
            path = path.substring(0, index);
        }
        return path;
    }
}

