/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import org.resteasy.Failure;
import org.resteasy.ValueInjector;
import org.resteasy.spi.HttpRequest;
import org.resteasy.spi.HttpResponse;
import org.resteasy.spi.ResteasyProviderFactory;

public class MessageBodyParameterInjector
implements ValueInjector {
    private Class type;
    private Type genericType;
    private Annotation[] annotations;
    private ResteasyProviderFactory factory;

    public MessageBodyParameterInjector(Class type, Type genericType, Annotation[] annotations, ResteasyProviderFactory factory) {
        this.type = type;
        this.factory = factory;
        this.genericType = genericType;
        this.annotations = annotations;
    }

    public Object inject(HttpRequest request, HttpResponse response) {
        try {
            MediaType mediaType = request.getHttpHeaders().getMediaType();
            if (mediaType == null) {
                System.err.println("content-type was null and expecting to extract a body");
                throw new WebApplicationException(400);
            }
            MessageBodyReader reader = this.factory.createMessageBodyReader(this.type, this.genericType, this.annotations, mediaType);
            if (reader == null) {
                throw new Failure("Could not find message body reader for type: " + this.genericType + " of content type: " + mediaType, 400);
            }
            return reader.readFrom(this.type, this.genericType, this.annotations, mediaType, request.getHttpHeaders().getRequestHeaders(), request.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Failure extracting body", e);
        }
    }

    public Object inject() {
        throw new RuntimeException("Illegal to inject a message body into a singleton");
    }
}

