/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.python.icu.impl.ICUCache;
import org.python.icu.impl.ICUResourceBundle;
import org.python.icu.impl.SimpleCache;
import org.python.icu.util.ULocale;
import org.python.icu.util.UResourceBundle;

@Deprecated
public class GenderInfo {
    private final ListGenderStyle style;
    private static GenderInfo neutral = new GenderInfo(ListGenderStyle.NEUTRAL);
    private static Cache genderInfoCache = new Cache();

    @Deprecated
    public static GenderInfo getInstance(ULocale uLocale) {
        return genderInfoCache.get(uLocale);
    }

    @Deprecated
    public static GenderInfo getInstance(Locale locale2) {
        return GenderInfo.getInstance(ULocale.forLocale(locale2));
    }

    @Deprecated
    public Gender getListGender(Gender ... genders) {
        return this.getListGender(Arrays.asList(genders));
    }

    @Deprecated
    public Gender getListGender(List<Gender> genders) {
        if (genders.size() == 0) {
            return Gender.OTHER;
        }
        if (genders.size() == 1) {
            return genders.get(0);
        }
        switch (this.style) {
            case NEUTRAL: {
                return Gender.OTHER;
            }
            case MIXED_NEUTRAL: {
                boolean hasFemale = false;
                boolean hasMale = false;
                for (Gender gender : genders) {
                    switch (gender) {
                        case FEMALE: {
                            if (hasMale) {
                                return Gender.OTHER;
                            }
                            hasFemale = true;
                            break;
                        }
                        case MALE: {
                            if (hasFemale) {
                                return Gender.OTHER;
                            }
                            hasMale = true;
                            break;
                        }
                        case OTHER: {
                            return Gender.OTHER;
                        }
                    }
                }
                return hasMale ? Gender.MALE : Gender.FEMALE;
            }
            case MALE_TAINTS: {
                for (Gender gender : genders) {
                    if (gender == Gender.FEMALE) continue;
                    return Gender.MALE;
                }
                return Gender.FEMALE;
            }
        }
        return Gender.OTHER;
    }

    @Deprecated
    public GenderInfo(ListGenderStyle genderStyle) {
        this.style = genderStyle;
    }

    private static class Cache {
        private final ICUCache<ULocale, GenderInfo> cache = new SimpleCache<ULocale, GenderInfo>();

        private Cache() {
        }

        public GenderInfo get(ULocale locale2) {
            GenderInfo result2 = this.cache.get(locale2);
            if (result2 == null) {
                result2 = Cache.load(locale2);
                if (result2 == null) {
                    ULocale fallback = locale2.getFallback();
                    result2 = fallback == null ? neutral : this.get(fallback);
                }
                this.cache.put(locale2, result2);
            }
            return result2;
        }

        private static GenderInfo load(ULocale ulocale) {
            UResourceBundle rb = UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt59b", "genderList", ICUResourceBundle.ICU_DATA_CLASS_LOADER, true);
            UResourceBundle genderList = rb.get("genderList");
            try {
                return new GenderInfo(ListGenderStyle.fromName(genderList.getString(ulocale.toString())));
            }
            catch (MissingResourceException mre) {
                return null;
            }
        }
    }

    @Deprecated
    public static enum ListGenderStyle {
        NEUTRAL,
        MIXED_NEUTRAL,
        MALE_TAINTS;

        private static Map<String, ListGenderStyle> fromNameMap;

        @Deprecated
        public static ListGenderStyle fromName(String name) {
            ListGenderStyle result2 = fromNameMap.get(name);
            if (result2 == null) {
                throw new IllegalArgumentException("Unknown gender style name: " + name);
            }
            return result2;
        }

        static {
            fromNameMap = new HashMap<String, ListGenderStyle>(3);
            fromNameMap.put("neutral", NEUTRAL);
            fromNameMap.put("maleTaints", MALE_TAINTS);
            fromNameMap.put("mixedNeutral", MIXED_NEUTRAL);
        }
    }

    @Deprecated
    public static enum Gender {
        MALE,
        FEMALE,
        OTHER;

    }
}

