/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.AccessLevel;
import lombok.ConfigurationKeys;
import lombok.Value;
import lombok.core.AST;
import lombok.core.AnnotationValues;
import lombok.core.HandlerPriority;
import lombok.core.handlers.HandlerUtil;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseHandlerUtil;
import lombok.eclipse.handlers.HandleConstructor;
import lombok.eclipse.handlers.HandleSetter;
import lombok.eclipse.handlers.HandleToString;
import lombok.eclipse.handlers.SetGeneratedByVisitor;
import lombok.experimental.Builder;
import lombok.experimental.NonFinal;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HandlerPriority(value=-1024)
public class HandleBuilder
extends EclipseAnnotationHandler<Builder> {
    private static final AbstractMethodDeclaration[] EMPTY = new AbstractMethodDeclaration[0];

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(AnnotationValues<Builder> annotation, Annotation ast, EclipseNode annotationNode) {
        MethodDeclaration md;
        ConstructorDeclaration cd;
        EclipseNode builderType;
        char[] nameOfStaticBuilderMethod;
        TypeReference[] thrownExceptions;
        TypeParameter[] typeParams;
        TypeReference returnType;
        EclipseNode tdParent;
        HandlerUtil.handleExperimentalFlagUsage(annotationNode, ConfigurationKeys.BUILDER_FLAG_USAGE, "@Builder");
        long p = (long)ast.sourceStart << 32 | (long)ast.sourceEnd;
        Builder builderInstance = annotation.getInstance();
        String builderMethodName = builderInstance.builderMethodName();
        String buildMethodName = builderInstance.buildMethodName();
        String builderClassName = builderInstance.builderClassName();
        if (builderMethodName == null) {
            builderMethodName = "builder";
        }
        if (buildMethodName == null) {
            builderMethodName = "build";
        }
        if (builderClassName == null) {
            builderClassName = "";
        }
        if (!HandlerUtil.checkName("builderMethodName", builderMethodName, annotationNode)) {
            return;
        }
        if (!HandlerUtil.checkName("buildMethodName", buildMethodName, annotationNode)) {
            return;
        }
        if (!builderClassName.isEmpty() && !HandlerUtil.checkName("builderClassName", builderClassName, annotationNode)) {
            return;
        }
        EclipseNode parent = (EclipseNode)annotationNode.up();
        ArrayList<TypeReference> typesOfParameters = new ArrayList<TypeReference>();
        ArrayList<char[]> namesOfParameters = new ArrayList<char[]>();
        ConstructorDeclaration fillParametersFrom = null;
        if (parent.get() instanceof TypeDeclaration) {
            tdParent = parent;
            TypeDeclaration td = (TypeDeclaration)tdParent.get();
            ArrayList<EclipseNode> fields = new ArrayList<EclipseNode>();
            boolean valuePresent = EclipseHandlerUtil.hasAnnotation(Value.class, parent) || EclipseHandlerUtil.hasAnnotation(lombok.experimental.Value.class, parent);
            for (EclipseNode eclipseNode : HandleConstructor.findAllFields(tdParent)) {
                FieldDeclaration fd = (FieldDeclaration)eclipseNode.get();
                if (fd.initialization != null && valuePresent && !EclipseHandlerUtil.hasAnnotation(NonFinal.class, eclipseNode)) continue;
                namesOfParameters.add(EclipseHandlerUtil.removePrefixFromField(eclipseNode));
                typesOfParameters.add(fd.type);
                fields.add(eclipseNode);
            }
            new HandleConstructor().generateConstructor(tdParent, AccessLevel.PACKAGE, fields, null, HandleConstructor.SkipIfConstructorExists.I_AM_BUILDER, null, Collections.<Annotation>emptyList(), annotationNode);
            returnType = EclipseHandlerUtil.namePlusTypeParamsToTypeReference(td.name, td.typeParameters, p);
            typeParams = td.typeParameters;
            thrownExceptions = null;
            nameOfStaticBuilderMethod = null;
            if (builderClassName.isEmpty()) {
                builderClassName = new String(td.name) + "Builder";
            }
        } else if (parent.get() instanceof ConstructorDeclaration) {
            ConstructorDeclaration cd2 = (ConstructorDeclaration)parent.get();
            if (cd2.typeParameters != null && cd2.typeParameters.length > 0) {
                annotationNode.addError("@Builder is not supported on constructors with constructor type parameters.");
                return;
            }
            tdParent = (EclipseNode)parent.up();
            TypeDeclaration td = (TypeDeclaration)tdParent.get();
            fillParametersFrom = cd2;
            returnType = EclipseHandlerUtil.namePlusTypeParamsToTypeReference(td.name, td.typeParameters, p);
            typeParams = td.typeParameters;
            thrownExceptions = cd2.thrownExceptions;
            nameOfStaticBuilderMethod = null;
            if (builderClassName.isEmpty()) {
                builderClassName = new String(cd2.selector) + "Builder";
            }
        } else if (parent.get() instanceof MethodDeclaration) {
            MethodDeclaration md2 = (MethodDeclaration)parent.get();
            tdParent = (EclipseNode)parent.up();
            if (!md2.isStatic()) {
                annotationNode.addError("@Builder is only supported on types, constructors, and static methods.");
                return;
            }
            fillParametersFrom = md2;
            returnType = EclipseHandlerUtil.copyType(md2.returnType, (ASTNode)ast);
            typeParams = md2.typeParameters;
            thrownExceptions = md2.thrownExceptions;
            nameOfStaticBuilderMethod = md2.selector;
            if (builderClassName.isEmpty()) {
                char[] token;
                if (md2.returnType instanceof QualifiedTypeReference) {
                    char[][] tokens = ((QualifiedTypeReference)md2.returnType).tokens;
                    token = tokens[tokens.length - 1];
                } else if (md2.returnType instanceof SingleTypeReference) {
                    token = ((SingleTypeReference)md2.returnType).token;
                    if (!(md2.returnType instanceof ParameterizedSingleTypeReference) && typeParams != null) {
                        void var19_25;
                        TypeParameter[] arr$ = typeParams;
                        int len$ = arr$.length;
                        boolean bl = false;
                        while (var19_25 < len$) {
                            TypeParameter tp = arr$[var19_25];
                            if (Arrays.equals(tp.name, token)) {
                                annotationNode.addError("@Builder requires specifying 'builderClassName' if used on methods with a type parameter as return type.");
                                return;
                            }
                            ++var19_25;
                        }
                    }
                } else {
                    annotationNode.addError("Unexpected kind of return type on annotated method. Specify 'builderClassName' to solve this problem.");
                    return;
                }
                if (Character.isLowerCase(token[0])) {
                    char[] newToken = new char[token.length];
                    System.arraycopy(token, 1, newToken, 1, token.length - 1);
                    newToken[0] = Character.toTitleCase(token[0]);
                    token = newToken;
                }
                builderClassName = new String(token) + "Builder";
            }
        } else {
            annotationNode.addError("@Builder is only supported on types, constructors, and static methods.");
            return;
        }
        if (fillParametersFrom != null && fillParametersFrom.arguments != null) {
            for (Argument a : fillParametersFrom.arguments) {
                namesOfParameters.add(a.name);
                typesOfParameters.add(a.type);
            }
        }
        if ((builderType = this.findInnerClass(tdParent, builderClassName)) == null) {
            builderType = this.makeBuilderClass(tdParent, builderClassName, typeParams, (ASTNode)ast);
        } else {
            EclipseHandlerUtil.sanityCheckForMethodGeneratingAnnotationsOnBuilderClass(builderType, annotationNode);
        }
        List<EclipseNode> fieldNodes = this.addFieldsToBuilder(builderType, namesOfParameters, typesOfParameters, (ASTNode)ast);
        ArrayList<MethodDeclaration> newMethods = new ArrayList<MethodDeclaration>();
        for (EclipseNode eclipseNode : fieldNodes) {
            MethodDeclaration newMethod = this.makeSetterMethodForBuilder(builderType, eclipseNode, annotationNode, builderInstance.fluent(), builderInstance.chain());
            if (newMethod == null) continue;
            newMethods.add(newMethod);
        }
        if (EclipseHandlerUtil.constructorExists(builderType) == EclipseHandlerUtil.MemberExistsResult.NOT_EXISTS && (cd = HandleConstructor.createConstructor(AccessLevel.PACKAGE, builderType, Collections.<EclipseNode>emptyList(), null, annotationNode, Collections.<Annotation>emptyList())) != null) {
            EclipseHandlerUtil.injectMethod(builderType, (AbstractMethodDeclaration)cd);
        }
        for (AbstractMethodDeclaration abstractMethodDeclaration : newMethods) {
            EclipseHandlerUtil.injectMethod(builderType, abstractMethodDeclaration);
        }
        if (EclipseHandlerUtil.methodExists(buildMethodName, builderType, -1) == EclipseHandlerUtil.MemberExistsResult.NOT_EXISTS && (md = this.generateBuildMethod(buildMethodName, nameOfStaticBuilderMethod, returnType, namesOfParameters, builderType, (ASTNode)ast, thrownExceptions)) != null) {
            EclipseHandlerUtil.injectMethod(builderType, (AbstractMethodDeclaration)md);
        }
        if (EclipseHandlerUtil.methodExists("toString", builderType, 0) == EclipseHandlerUtil.MemberExistsResult.NOT_EXISTS && (md = HandleToString.createToString(builderType, fieldNodes, true, false, (ASTNode)ast, EclipseHandlerUtil.FieldAccess.ALWAYS_FIELD)) != null) {
            EclipseHandlerUtil.injectMethod(builderType, (AbstractMethodDeclaration)md);
        }
        if (EclipseHandlerUtil.methodExists(builderMethodName, tdParent, -1) == EclipseHandlerUtil.MemberExistsResult.NOT_EXISTS && (md = this.generateBuilderMethod(builderMethodName, builderClassName, tdParent, typeParams, (ASTNode)ast)) != null) {
            EclipseHandlerUtil.injectMethod(tdParent, (AbstractMethodDeclaration)md);
        }
    }

    public MethodDeclaration generateBuilderMethod(String builderMethodName, String builderClassName, EclipseNode type, TypeParameter[] typeParams, ASTNode source) {
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        MethodDeclaration out = new MethodDeclaration(((CompilationUnitDeclaration)((EclipseNode)type.top()).get()).compilationResult);
        out.selector = builderMethodName.toCharArray();
        out.modifiers = 9;
        out.bits |= 0x800000;
        out.returnType = EclipseHandlerUtil.namePlusTypeParamsToTypeReference(builderClassName.toCharArray(), typeParams, p);
        out.typeParameters = EclipseHandlerUtil.copyTypeParams(typeParams, source);
        AllocationExpression invoke = new AllocationExpression();
        invoke.type = EclipseHandlerUtil.namePlusTypeParamsToTypeReference(builderClassName.toCharArray(), typeParams, p);
        out.statements = new Statement[]{new ReturnStatement((Expression)invoke, pS, pE)};
        out.traverse((ASTVisitor)new SetGeneratedByVisitor(source), ((TypeDeclaration)type.get()).scope);
        return out;
    }

    public MethodDeclaration generateBuildMethod(String name, char[] staticName, TypeReference returnType, List<char[]> fieldNames, EclipseNode type, ASTNode source, TypeReference[] thrownExceptions) {
        Object statement;
        int pS = source.sourceStart;
        int pE = source.sourceEnd;
        long p = (long)pS << 32 | (long)pE;
        MethodDeclaration out = new MethodDeclaration(((CompilationUnitDeclaration)((EclipseNode)type.top()).get()).compilationResult);
        out.modifiers = 1;
        TypeDeclaration typeDecl = (TypeDeclaration)type.get();
        out.selector = name.toCharArray();
        out.thrownExceptions = EclipseHandlerUtil.copyTypes(thrownExceptions, source);
        out.bits |= 0x800000;
        out.returnType = returnType;
        ArrayList<SingleNameReference> assigns = new ArrayList<SingleNameReference>();
        for (char[] fieldName : fieldNames) {
            SingleNameReference nameRef = new SingleNameReference(fieldName, p);
            assigns.add(nameRef);
        }
        if (staticName == null) {
            AllocationExpression allocationStatement = new AllocationExpression();
            allocationStatement.type = EclipseHandlerUtil.copyType(out.returnType, source);
            allocationStatement.arguments = assigns.isEmpty() ? null : assigns.toArray(new Expression[assigns.size()]);
            statement = new ReturnStatement((Expression)allocationStatement, (int)(p >> 32), (int)p);
        } else {
            MessageSend invoke = new MessageSend();
            invoke.selector = staticName;
            invoke.receiver = new SingleNameReference(((EclipseNode)type.up()).getName().toCharArray(), p);
            TypeParameter[] tps = ((TypeDeclaration)type.get()).typeParameters;
            if (tps != null) {
                TypeReference[] trs = new TypeReference[tps.length];
                for (int i = 0; i < trs.length; ++i) {
                    trs[i] = new SingleTypeReference(tps[i].name, p);
                }
                invoke.typeArguments = trs;
            }
            invoke.arguments = assigns.isEmpty() ? null : assigns.toArray(new Expression[assigns.size()]);
            statement = returnType instanceof SingleTypeReference && Arrays.equals(TypeConstants.VOID, ((SingleTypeReference)returnType).token) ? invoke : new ReturnStatement((Expression)invoke, (int)(p >> 32), (int)p);
        }
        out.statements = new Statement[]{statement};
        out.traverse((ASTVisitor)new SetGeneratedByVisitor(source), typeDecl.scope);
        return out;
    }

    public List<EclipseNode> addFieldsToBuilder(EclipseNode builderType, List<char[]> namesOfParameters, List<TypeReference> typesOfParameters, ASTNode source) {
        int len = namesOfParameters.size();
        TypeDeclaration td = (TypeDeclaration)builderType.get();
        FieldDeclaration[] existing = td.fields;
        if (existing == null) {
            existing = new FieldDeclaration[]{};
        }
        ArrayList<EclipseNode> out = new ArrayList<EclipseNode>();
        block0: for (int i = len - 1; i >= 0; --i) {
            char[] name = namesOfParameters.get(i);
            for (FieldDeclaration exists : existing) {
                if (!Arrays.equals(exists.name, name)) continue;
                out.add((EclipseNode)builderType.getNodeFor(exists));
                continue block0;
            }
            TypeReference fieldReference = EclipseHandlerUtil.copyType(typesOfParameters.get(i), source);
            FieldDeclaration newField = new FieldDeclaration(name, 0, 0);
            newField.bits |= 0x800000;
            newField.modifiers = 2;
            newField.type = fieldReference;
            out.add(EclipseHandlerUtil.injectField(builderType, newField));
        }
        Collections.reverse(out);
        return out;
    }

    public MethodDeclaration makeSetterMethodForBuilder(EclipseNode builderType, EclipseNode fieldNode, EclipseNode sourceNode, boolean fluent, boolean chain) {
        TypeDeclaration td = (TypeDeclaration)builderType.get();
        AbstractMethodDeclaration[] existing = td.methods;
        if (existing == null) {
            existing = EMPTY;
        }
        int len = existing.length;
        FieldDeclaration fd = (FieldDeclaration)fieldNode.get();
        char[] name = fd.name;
        for (int i = 0; i < len; ++i) {
            char[] existingName;
            if (!(existing[i] instanceof MethodDeclaration) || !Arrays.equals(name, existingName = existing[i].selector)) continue;
            return null;
        }
        boolean isBoolean = EclipseHandlerUtil.isBoolean(fd.type);
        String setterName = fluent ? fieldNode.getName() : HandlerUtil.toSetterName(builderType.getAst(), null, fieldNode.getName(), isBoolean);
        return HandleSetter.createSetter(td, fieldNode, setterName, chain, 1, sourceNode, Collections.<Annotation>emptyList(), Collections.<Annotation>emptyList());
    }

    public EclipseNode findInnerClass(EclipseNode parent, String name) {
        char[] c = name.toCharArray();
        for (EclipseNode child : parent.down()) {
            if (child.getKind() != AST.Kind.TYPE) continue;
            TypeDeclaration td = (TypeDeclaration)child.get();
            if (!Arrays.equals(td.name, c)) continue;
            return child;
        }
        return null;
    }

    public EclipseNode makeBuilderClass(EclipseNode tdParent, String builderClassName, TypeParameter[] typeParams, ASTNode source) {
        TypeDeclaration parent = (TypeDeclaration)tdParent.get();
        TypeDeclaration builder = new TypeDeclaration(parent.compilationResult);
        builder.bits |= 0x800000;
        builder.modifiers |= 9;
        builder.typeParameters = EclipseHandlerUtil.copyTypeParams(typeParams, source);
        builder.name = builderClassName.toCharArray();
        builder.traverse((ASTVisitor)new SetGeneratedByVisitor(source), (ClassScope)null);
        return EclipseHandlerUtil.injectType(tdParent, builder);
    }
}

