/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.importconstants;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.primefaces.extensions.component.importconstants.ConstantsHashMap;
import org.primefaces.extensions.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportConstantsTagHandler
extends TagHandler {
    private static final Map<ClassLoader, Map<Class<?>, Map<String, Object>>> CACHE = new ConcurrentHashMap();
    private final TagAttribute classNameTagAttribute = super.getRequiredAttribute("className");
    private final TagAttribute varTagAttribute = super.getAttribute("var");

    public ImportConstantsTagHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        Class<?> clazz = this.getClassFromAttribute(this.classNameTagAttribute, ctx);
        Map<String, Object> constants = this.getConstants(clazz);
        String var = this.varTagAttribute == null ? clazz.getSimpleName() : this.varTagAttribute.getValue(ctx);
        if (var.charAt(0) != '#') {
            StringBuilder varBuilder = new StringBuilder();
            varBuilder.append("#{").append(var).append("}");
            var = varBuilder.toString();
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = facesContext.getELContext();
        ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
        ValueExpression aliasValueExpression = expressionFactory.createValueExpression(elContext, var, Map.class);
        aliasValueExpression.setValue(elContext, constants);
    }

    protected Class<?> getClassFromAttribute(TagAttribute attribute, FaceletContext ctx) {
        String className = attribute.getValue(ctx);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new FacesException("Class " + className + " not found.", (Throwable)e);
        }
    }

    protected Map<String, Object> getConstants(Class<?> clazz) {
        Map<String, Object> constants;
        Map<Class<?>, Map<String, Object>> cache;
        ClassLoader classLoader = ClassUtils.getClassLoader(clazz);
        if (!CACHE.containsKey(classLoader)) {
            CACHE.put(classLoader, new ConcurrentHashMap());
        }
        if ((cache = CACHE.get(classLoader)).containsKey(clazz)) {
            constants = cache.get(clazz);
        } else {
            constants = this.collectConstants(clazz);
            cache.put(clazz, constants);
        }
        return constants;
    }

    protected Map<String, Object> collectConstants(Class<?> clazz) {
        ConstantsHashMap<String, Object> constants = new ConstantsHashMap<String, Object>(clazz);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            int modifiers = fields[i].getModifiers();
            if (!Modifier.isFinal(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            try {
                Object value = fields[i].get(null);
                constants.put(fields[i].getName(), value);
                continue;
            }
            catch (Exception e) {
                throw new FacesException("Could not get value of " + fields[i].getName() + " in " + clazz.getName() + ".", (Throwable)e);
            }
        }
        return constants;
    }
}

