/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xpath.expr;

import org.planx.xpath.Context;
import org.planx.xpath.Environment;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.expr.Expression;
import org.planx.xpath.expr.PredicateList;
import org.planx.xpath.object.XNodeSet;
import org.planx.xpath.object.XObject;

public class FilterExpression
extends Expression {
    private final Expression expr;
    private final PredicateList predicates;

    public FilterExpression(Expression expr, PredicateList predicates) {
        this.expr = expr;
        this.predicates = predicates;
    }

    @Override
    public XObject evaluate(Context ctxt, Environment env, Navigator nav) throws XPathException {
        try {
            XNodeSet values = (XNodeSet)this.expr.evaluate(ctxt, env, nav);
            return this.predicates.evaluate(values, env, nav);
        }
        catch (ClassCastException e) {
            throw new XPathException("Expression did not evaluate to an XNodeSet: " + this.expr);
        }
    }

    public String toString() {
        return this.expr.toString() + this.predicates.toString();
    }
}

