/*
 * Decompiled with CFR 0.152.
 */
package org.planx.xmlstore.routing;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.planx.xmlstore.routing.Identifier;
import org.planx.xmlstore.routing.Node;
import org.planx.xmlstore.routing.Space;
import org.planx.xmlstore.routing.TimestampedEntry;
import org.planx.xmlstore.routing.TimestampedValue;

public class HashCalculator {
    public static final int HASH_LENGTH = 16;
    public static final long UNIT_INTERVAL = 3600000L;
    private Node local;
    private Space space;
    private Map localMap;

    public HashCalculator(Node local, Space space, Map localMap) {
        this.local = local;
        this.space = space;
        this.localMap = localMap;
    }

    public List logarithmicHashes(Node node, long time) {
        List mappings = this.mappingsBetween(node, Long.MIN_VALUE, Long.MAX_VALUE);
        ArrayList<byte[]> hashes = new ArrayList<byte[]>();
        long interval = 3600000L;
        while (mappings.size() > 0) {
            List bundle = this.tailFrom(mappings, time);
            hashes.add(this.calculateHash(bundle));
            time -= interval;
            interval *= 2L;
        }
        return hashes;
    }

    private List tailFrom(List mappings, long time) {
        TimestampedEntry entry;
        ArrayList<TimestampedEntry> tail = new ArrayList<TimestampedEntry>();
        while (mappings.size() > 0 && (entry = (TimestampedEntry)mappings.get(mappings.size() - 1)).getValue().timestamp() >= time) {
            tail.add(entry);
            mappings.remove(mappings.size() - 1);
        }
        return tail;
    }

    public List mappingsBetween(Node node, long begin, long end) {
        ArrayList<TimestampedEntry> mappings = new ArrayList<TimestampedEntry>();
        for (Map.Entry entry : this.localMap.entrySet()) {
            TimestampedValue value;
            Identifier key = (Identifier)entry.getKey();
            List closest = this.space.getClosestNodes(key);
            if (!closest.contains(node) || !closest.contains(this.local) || begin > (value = (TimestampedValue)entry.getValue()).timestamp() || value.timestamp() >= end) continue;
            mappings.add(new TimestampedEntry(key, value));
        }
        Collections.sort(mappings, TimestampedEntry.TIMESTAMP_COMPARATOR);
        return mappings;
    }

    public byte[] calculateHash(List bundle) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (md.getDigestLength() != 16) {
                throw new RuntimeException("Unexpected hash length " + md.getDigestLength() + " - expected " + 16);
            }
            int max = bundle.size();
            for (int i = 0; i < max; ++i) {
                TimestampedEntry entry = (TimestampedEntry)bundle.get(i);
                md.update(entry.getKey().toByteArray());
                md.update(entry.getValue().getByteArray());
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

