package org.planx.xpath.object;

import org.planx.xpath.XPathException;

/**
 * A string value returned by an XPath expression.
 **/
public class XString extends XSimple {
    private final String value;

    /**
     * Construct a XString from the specified string.
     **/
    public XString(String s) {
        this.value = s;
    }

    // Conversion

    /**
     * Returns <code>true</code> if this XString does
     * not represent the empty string. Otherwise returns
     * <code>false</code>.
     **/
    public boolean booleanValue() {
        return value.length() > 0;
    }

    /**
     * Returns the double value of this XString.
     **/
    public double doubleValue() {
        try {
            return Double.parseDouble(value);
        } catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    /**
     * Returns the double value of the specified String.
     **/
    public static double doubleValue(String s) {
        try {
            return Double.parseDouble(s);
        } catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    /**
     * Returns the string value of this XString.
     **/
    public String stringValue() {
        return value;
    }

    /**
     * Returns the string value of this XString.
     **/
    public String toString() {
        return value;
    }

    // Override methods in Object

    /**
     * Returns true if and only if <code>o</code> is
     * an instance of XString and it has the same string
     * value as this.
     **/
    public boolean equals(Object o) {
        if (o instanceof XString) {
            XString other = (XString) o;
            return value.equals(other.value);
        }
        return false;
    }

    /**
     * Returns a hash code value for this object.
     **/
    public int hashCode() {
        return value.hashCode();
    }
}

