package org.planx.xpath.object;

import org.planx.xpath.XPathException;

/**
 * A boolean value returned by an XPath expression.
 **/
public class XBoolean extends XSimple {
    private final boolean value;
    public static final XBoolean FALSE = new XBoolean(false);
    public static final XBoolean TRUE = new XBoolean(true);

    /**
     * Construct an XBoolean with the specified
     * boolean value.
     **/
    public XBoolean(boolean value) {
        this.value = value;
    }

    // Conversion

    /**
     * Returns the boolean value of this XBoolean.
     **/
    public boolean booleanValue() {
        return value;
    }

    /**
     * Returns the double value of this XBoolean.
     * <code>true</code> is converted to 1 and
     * <code>false</code> is converted to 0.
     **/
    public double doubleValue() {
        return value ? 1D : 0D;
    }

    /**
     * Returns the string "true" if this XBoolean represents
     * the value <code>true</code>. Otherwise returns the string "false".
     **/
    public String stringValue() {
        return (value) ? "true" : "false";
    }

    /**
     * Returns the string "true" if this XBoolean represents
     * the value <code>true</code>. Otherwise returns the string "false".
     **/
    public String toString() {
        return stringValue();
    }

    // Override methods in Object

    /**
     * Returns true if and only if <code>o</code> is
     * an instance of XBoolean and it has the same boolean
     * value as this.
     **/
    public boolean equals(Object o) {
        if (o instanceof XBoolean) {
            return value == ((XBoolean) o).value;
        }
        return false;
    }

    /**
     * Returns a hash code value for this object.
     **/
    public int hashCode() {
        // Note: These values might seem peculiar, but it is what
        // is returned by the hashCode() method in java.lang.Boolean
        return (value) ? 1231 : 1237;
    }
}

