package org.planx.xpath.expr.axis;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;

public class SelfAxis extends Axis {
    public SelfAxis() {
    }

    public AxisIterator iterator(Object contextNode, Navigator navigator)
                                                throws XPathException {
        return new SelfAxisIterator(contextNode, navigator);
    }

    /**
     * The principal node type of this axis is
     * {@link Navigator#ELEMENT}.
     **/
    public int getPrincipalNodeType() {
        return Navigator.ELEMENT;
    }

    public boolean isReverse() {
        return false;
    }

    public String toString() {
        return "self";
    }

    class SelfAxisIterator implements AxisIterator {
        private Object contextNode;
        private boolean isDone = false;

        SelfAxisIterator(Object contextNode, Navigator navigator)
                                          throws XPathException {
            this.contextNode = contextNode;
        }

        public boolean hasNext() {
            return !isDone && (contextNode != null);
        }

        public Object next() throws XPathException {
            if (isDone) throw new XPathException(
                  "No more elements in iterator");
            isDone = true;
            return contextNode;
        }
    }
}
