package org.planx.xpath.expr.axis;

import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;

/**
 * An XPath axis.
 **/
public abstract class Axis {
    /**
     * Return an iterator over the nodes of this axis.
     **/
    public abstract AxisIterator iterator(Object contextNode,
                    Navigator navigator) throws XPathException;


    /**
     * Returns the principal node type of the axis as
     * specified in {@link Navigator}.
     **/
    public abstract int getPrincipalNodeType();

    /**
     * Returns <code>true</code> if this axis is a reverse axis.
     * I.e. returns nodes in reverse document order.
     **/
    public abstract boolean isReverse();
}
