package org.planx.xpath.expr;

import java.util.List;
import org.planx.xpath.Context;
import org.planx.xpath.Environment;
import org.planx.xpath.Navigator;
import org.planx.xpath.XPathException;
import org.planx.xpath.function.Function;
import org.planx.xpath.object.*;

/**
 * Represents a function call.
 **/
public class FunctionCall extends Expression {
    private final String funcName;
    private final List args;

    public FunctionCall(String funcName) {
        this(funcName, null);
    }

    public FunctionCall(String funcName, List args) {
        this.funcName = funcName;
        this.args = args;
    }

    public XObject evaluate(Context ctxt, Environment env, Navigator nav)
                                                   throws XPathException {
        int argsize = (args == null) ? 0 : args.size();
        XObject[] argvalues = new XObject[argsize];

        for (int i = 0; i < argsize; i++) {
            Expression expr = (Expression) args.get(i);
            argvalues[i] = expr.evaluate(ctxt, env, nav);
        }
        Function function = env.getFunction(funcName);
        return function.evaluate(argvalues, ctxt, env, nav);
    }

    public String toString() {
        if ((args == null) || args.isEmpty()) return funcName+"()";
        else return funcName+"("+args+")";
    }
}
