package org.planx.xmlstore.stores;

import java.io.IOException;
import java.util.Map;
import org.planx.xmlstore.*;
import org.planx.util.*;

/**
 * @author Kasper Bøgebjerg
 * @author Henning Niss
 */
public class ReadCacheXMLStore extends AbstractXMLStore {
    private Map<Reference,Node> cache;

    public ReadCacheXMLStore(XMLStore xmlstore) {
        super(xmlstore);
        cache = new LRUCache<Reference,Node>();
    }

    public Node load(Reference vref) throws IOException,
                              UnknownReferenceException {
        checkClosed();
        Node n = cache.get(vref);
        if (n == null) {
            n = xmlstore.load(vref);
            cache.put(vref, n);
        }
        return n;
    }

    public void close() throws IOException {
        super.close();
        cache = null;
    }
}
