package org.planx.xmlstore.routing;

import java.net.InetSocketAddress;

/**
 * Listens for newly arrived nodes in the neighbourhood of the local node.
 **/
public interface NeighbourhoodListener {
    /**
     * A new node has arrived. The InetSocketAddress consists of the IP number of
     * the peer and the contact port specified using the {@link DistributedMap#setContactPort}
     * method at the peer.
     **/
    public void peerArrived(InetSocketAddress peer);
}
