package org.planx.xmlstore.nodes;

import java.util.ArrayList;
import java.util.List;
import org.planx.msd.graph.*;
import org.planx.xmlstore.Reference;
import org.planx.xmlstore.io.LocalLocator;

/**
 * Chooses the first node in an equivalence class as the canonical node.
 * Subclass to override policy. If bounds are <code>null</code> no node
 * will be considered outside.
 */
public class NodeNavigator implements Navigator<SystemNode> {
    protected LocalLocator bound1 = null;
    protected LocalLocator bound2 = null;

    public NodeNavigator() {}

    public void setBounds(LocalLocator bound1, LocalLocator bound2) {
        this.bound1 = bound1;
        this.bound2 = bound2;
    }

    public boolean isOutside(SystemNode node) {
        LocalLocator loc = node.getLocator();
        if (loc == null) return false;
        if (bound1 != null && bound1.isContained(loc)) return false;
        if (bound2 != null && bound2.isContained(loc)) return false;
        return true;
    }

    public SystemNode chooseCanonical(List<Compactor<SystemNode>.Edge> eqCls) {
        return eqCls.get(0).node;
    }

    public SystemNode getChild(SystemNode node, int index) {
        return node.getChildren().get(index);
    }

    public void setChild(SystemNode node, int index, SystemNode child) {
        node.setChild(index, child);
    }

    public int childCount(SystemNode node) {
        return node.getChildren().size();
    }

    public Object getVisitToken(SystemNode node) {
        return node.getVisitToken();
    }

    public void setVisitToken(SystemNode node, Object token) {
        node.setVisitToken(token);
    }

    public int getHeight(SystemNode node) {
        return node.getHeight();
    }

    public void setHeight(SystemNode node, int height) {
        node.setHeight(height);
    }
}
