package org.planx.xmlstore;

import java.io.IOException;

/**
 * @author Henning Niss
 */
public interface NameServer {
    /**
     * Lookup the name in the name server.
     * The method will return null if the name is not currently
     * bound.
     *
     * @param name  the name to be looked up
     * @return the reference bound to the name, or null
     *      if the name is not currently bound
     */
    public Reference lookup(String name) throws IOException;

    /**
     * Bind the name to the value reference in the name server.
     *
     * @param name the name to be bound
     * @param ref  the reference to bind it to
     * @throws NameAlreadyBoundException if the name is
     *      already bound (to a different value reference).
     * @throws IOException
     */
    public void bind(String name, Reference ref) throws IOException,
                                          NameAlreadyBoundException;


    /**
     * Rebind the name to the value reference in the name server
     * if the name is currently bound to the specified value reference.
     *
     * @param name    the name to be bound
     * @param oldRef  the reference to which name is currently bound
     * @param newRef  the reference to bind it to
     * @throws StaleReferenceException if the name is
     *      bound to something different from oldRef.
     * @throws IOException
     */
    public void rebind(String name, Reference oldRef, Reference newRef)
                           throws IOException, StaleReferenceException;
}
