package org.planx.util;

import java.io.UnsupportedEncodingException;

/**
 * @author Kasper Bøgebjerg
 * @author Henning Niss
 * @author Thomas Ambus
 */
public class Converter {
    public static int bytes2int(byte[] ab, int i) {
        return ((ab[i] & 255) << 24) | ((ab[i + 1] & 255) << 16) |
               ((ab[i + 2] & 255) << 8) | (ab[i + 3] & 255);
    }

    public static byte[] int2bytes(int i) {
        byte[] ab = new byte[4];
        ab[0] = (byte) (255 & i >> 24);
        ab[1] = (byte) (255 & i >> 16);
        ab[2] = (byte) (255 & i >> 8);
        ab[3] = (byte) (255 & i);
        return ab;
    }

    public static void int2bytebuf(int i, int off, byte[] ab) {
        if (ab.length < off+4) {
            throw new ArrayIndexOutOfBoundsException("ab.length: " + ab.length + " off: " + off + " ab: " + new String(ab));
        }
        ab[off] = (byte) (255 & i >> 24);
        ab[off + 1] = (byte) (255 & i >> 16);
        ab[off + 2] = (byte) (255 & i >> 8);
        ab[off + 3] = (byte) (255 & i);
    }

    public static String toHex(byte b) {
        String h = Integer.toHexString(b & 0xFF);
        if (h.length()==1) { return "0"+h; }
        else { return h; }
    }

    public static String toHex(byte[] bs) {
        StringBuilder sb = new StringBuilder(2*bs.length);
        for (int i=0; i<bs.length; i++) {
            sb.append(toHex(bs[i]));
        }
        return sb.toString();
    }

    /* helper to speed up getBytes() */
    public static byte[] getBytes(String str) {
        return getBytes(str,"ISO-8859-1");
    }

    /* helper to speed up getBytes() */
    public static byte[] getBytes(String str, String enc) {
        try {
            return str.getBytes(enc);
        } catch (UnsupportedEncodingException e) {
            return str.getBytes();
        }
    }
}
