package org.planx.msd.character;

import java.util.Collection;
import java.util.ArrayList;
import java.util.List;
import org.planx.msd.*;
import org.planx.msd.list.*;
import org.planx.msd.util.*;

/**
 * A <code>Discriminator</code> capable of discriminating a multiset of
 * <code>List</code>s of <code>CharSequences</code>s considered as bags.
 * That is, two lists are considered equivalent if one is a permutation
 * of the other. This implementation sorts each list lexicographically
 * and employs a random access list discriminator afterwards.
 *
 * @author Thomas Ambus
 */
public class CharSequenceBagDiscriminator<T extends CharSequence>
                    extends AbstractDiscriminator<List<T>> {
    private LexicographicCharSequenceDiscriminator<T> sorter;
    private Discriminator<List<T>> listDisc;

    public CharSequenceBagDiscriminator(Memory memory) {
        sorter = new LexicographicCharSequenceDiscriminator<T>(memory);
        Discriminator<T> strDisc = new CharSequenceDiscriminator<T>(memory);
        listDisc = new SizeRandomAccessListDiscriminator<T>(strDisc, memory);
    }

    public <U,S> Collection<List<S>> discriminate(List<? extends U> values,
                                        Extractor<U,? extends List<T>,S> e) {
        for (U elm : values) {
            sorter.sort(e.getLabel(elm));
        }
        return listDisc.discriminate(values, e);
    }
}
