package org.planx.msd;

/**
 * An <code>Extractor</code> is capable of extracting a <i>label</i>
 * object <code>T</code> and a <i>value</i> object <code>S</code> from
 * a specific input type <code>U</code>.
 */
public interface Extractor<U,T,S> {
    /**
     * Returns the label of the specified element.
     */
    public T getLabel(U elm);

    /**
     * Returns the value of the specified element.
     */
    public S getValue(U elm);
}
