/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.owasp.dependencycheck.maven.BaseDependencyCheckMojo;
import org.owasp.dependencycheck.utils.Settings;

@Mojo(name="purge", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.NONE, requiresOnline=true)
public class PurgeMojo
extends BaseDependencyCheckMojo {
    public boolean canGenerateReport() {
        return false;
    }

    @Override
    public void runCheck() throws MojoExecutionException, MojoFailureException {
        if (this.getConnectionString() != null && !this.getConnectionString().isEmpty()) {
            this.getLog().error((CharSequence)"Unable to purge the local NVD when using a non-default connection string");
        } else {
            this.populateSettings();
            try {
                File db = new File(Settings.getDataDirectory(), "dc.h2.db");
                if (db.exists()) {
                    if (db.delete()) {
                        this.getLog().info((CharSequence)"Database file purged; local copy of the NVD has been removed");
                    } else {
                        this.getLog().error((CharSequence)String.format("Unable to delete '%s'; please delete the file manually", db.getAbsolutePath()));
                    }
                } else {
                    this.getLog().error((CharSequence)String.format("Unable to purge database; the database file does not exists: %s", db.getAbsolutePath()));
                }
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)"Unable to delete the database");
            }
            Settings.cleanup();
        }
    }

    public String getName(Locale locale) {
        return "dependency-check-purge";
    }

    public String getDescription(Locale locale) {
        return "Purges the local cache of the NVD dataT.";
    }
}

