/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.IOUtils;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DriverLoadException;
import org.owasp.dependencycheck.data.nvdcve.DriverLoader;
import org.owasp.dependencycheck.utils.DBUtils;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionFactory.class);
    public static final String DB_STRUCTURE_RESOURCE = "data/initialize.sql";
    public static final String DB_STRUCTURE_UPDATE_RESOURCE = "data/upgrade_%s.sql";
    public static final String UPGRADE_HELP_URL = "https://jeremylong.github.io/DependencyCheck/data/upgrade.html";
    private Driver driver = null;
    private String connectionString = null;
    private String userName = null;
    private String password = null;
    private int callDepth = 0;
    private final Settings settings;

    public ConnectionFactory(Settings settings) {
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initialize() throws DatabaseException {
        if (this.connectionString != null) {
            return;
        }
        Connection conn = null;
        try {
            String driverName = this.settings.getString("data.driver_name", "");
            String driverPath = this.settings.getString("data.driver_path", "");
            LOGGER.debug("Loading driver '{}'", (Object)driverName);
            try {
                if (!driverPath.isEmpty()) {
                    LOGGER.debug("Loading driver from: {}", (Object)driverPath);
                    this.driver = DriverLoader.load(driverName, driverPath);
                } else {
                    this.driver = DriverLoader.load(driverName);
                }
            }
            catch (DriverLoadException ex) {
                LOGGER.debug("Unable to load database driver", (Throwable)ex);
                throw new DatabaseException("Unable to load database driver", ex);
            }
            this.userName = this.settings.getString("data.user", "dcuser");
            this.password = this.settings.getString("data.password", "DC-Pass1337!");
            try {
                this.connectionString = this.settings.getConnectionString("data.connection_string", "data.file_name");
            }
            catch (IOException ex) {
                LOGGER.debug("Unable to retrieve the database connection string", (Throwable)ex);
                throw new DatabaseException("Unable to retrieve the database connection string", ex);
            }
            boolean shouldCreateSchema = false;
            try {
                if (this.connectionString.startsWith("jdbc:h2:file:")) {
                    shouldCreateSchema = !this.h2DataFileExists();
                    LOGGER.debug("Need to create DB Structure: {}", (Object)shouldCreateSchema);
                }
            }
            catch (IOException ioex) {
                LOGGER.debug("Unable to verify database exists", (Throwable)ioex);
                throw new DatabaseException("Unable to verify database exists", ioex);
            }
            LOGGER.debug("Loading database connection");
            LOGGER.debug("Connection String: {}", (Object)this.connectionString);
            LOGGER.debug("Database User: {}", (Object)this.userName);
            try {
                conn = this.connectionString.toLowerCase().contains("integrated security=true") || this.connectionString.toLowerCase().contains("trusted_connection=true") ? DriverManager.getConnection(this.connectionString) : DriverManager.getConnection(this.connectionString, this.userName, this.password);
            }
            catch (SQLException ex) {
                if (ex.getMessage().contains("java.net.UnknownHostException") && this.connectionString.contains("AUTO_SERVER=TRUE;")) {
                    this.connectionString = this.connectionString.replace("AUTO_SERVER=TRUE;", "");
                    try {
                        conn = DriverManager.getConnection(this.connectionString, this.userName, this.password);
                        this.settings.setString("data.connection_string", this.connectionString);
                        LOGGER.debug("Unable to start the database in server mode; reverting to single user mode");
                    }
                    catch (SQLException sqlex) {
                        LOGGER.debug("Unable to connect to the database", (Throwable)ex);
                        throw new DatabaseException("Unable to connect to the database", ex);
                    }
                }
                LOGGER.debug("Unable to connect to the database", (Throwable)ex);
                throw new DatabaseException("Unable to connect to the database", ex);
            }
            if (shouldCreateSchema) {
                try {
                    this.createTables(conn);
                }
                catch (DatabaseException dex) {
                    LOGGER.debug("", (Throwable)dex);
                    throw new DatabaseException("Unable to create the database structure", dex);
                }
            }
            try {
                this.ensureSchemaVersion(conn);
            }
            catch (DatabaseException dex) {
                LOGGER.debug("", (Throwable)dex);
                throw new DatabaseException("Database schema does not match this version of dependency-check", dex);
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    LOGGER.debug("An error occurred closing the connection", (Throwable)ex);
                }
            }
        }
    }

    public synchronized void cleanup() {
        if (this.driver != null) {
            DriverLoader.cleanup(this.driver);
            this.driver = null;
        }
        this.connectionString = null;
        this.userName = null;
        this.password = null;
    }

    public synchronized Connection getConnection() throws DatabaseException {
        this.initialize();
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(this.connectionString, this.userName, this.password);
        }
        catch (SQLException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new DatabaseException("Unable to connect to the database", ex);
        }
        return conn;
    }

    public boolean h2DataFileExists() throws IOException {
        return ConnectionFactory.h2DataFileExists(this.settings);
    }

    public static boolean h2DataFileExists(Settings configuration) throws IOException {
        File file = ConnectionFactory.getH2DataFile(configuration);
        return file.exists();
    }

    public static File getH2DataFile(Settings configuration) throws IOException {
        File dir = configuration.getH2DataDirectory();
        String fileName = configuration.getString("data.file_name");
        File file = new File(dir, fileName);
        return file;
    }

    public boolean isH2Connection() {
        return ConnectionFactory.isH2Connection(this.settings);
    }

    public static boolean isH2Connection(Settings configuration) {
        String connStr;
        try {
            connStr = configuration.getConnectionString("data.connection_string", "data.file_name");
        }
        catch (IOException ex) {
            LOGGER.debug("Unable to get connectionn string", (Throwable)ex);
            return false;
        }
        return connStr.startsWith("jdbc:h2:file:");
    }

    private void createTables(Connection conn) throws DatabaseException {
        LOGGER.debug("Creating database structure");
        try (InputStream is = FileUtils.getResourceAsStream((String)DB_STRUCTURE_RESOURCE);){
            String dbStructure = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            Statement statement = null;
            try {
                statement = conn.createStatement();
                statement.execute(dbStructure);
            }
            catch (SQLException ex) {
                LOGGER.debug("", (Throwable)ex);
                throw new DatabaseException("Unable to create database statement", ex);
            }
            finally {
                DBUtils.closeStatement(statement);
            }
        }
        catch (IOException ex) {
            throw new DatabaseException("Unable to create database schema", ex);
        }
    }

    private void updateSchema(Connection conn, DependencyVersion appExpectedVersion, DependencyVersion currentDbVersion) throws DatabaseException {
        block18: {
            if (this.connectionString.startsWith("jdbc:h2:file:")) {
                LOGGER.debug("Updating database structure");
                String updateFile = String.format(DB_STRUCTURE_UPDATE_RESOURCE, currentDbVersion.toString());
                try (InputStream is = FileUtils.getResourceAsStream((String)updateFile);){
                    if (is == null) {
                        throw new DatabaseException(String.format("Unable to load update file '%s'", updateFile));
                    }
                    String dbStructureUpdate = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    Statement statement = null;
                    try {
                        statement = conn.createStatement();
                        statement.execute(dbStructureUpdate);
                        break block18;
                    }
                    catch (SQLException ex) {
                        throw new DatabaseException(String.format("Unable to upgrade the database schema from %s to %s", currentDbVersion.toString(), appExpectedVersion.toString()), ex);
                    }
                    finally {
                        DBUtils.closeStatement(statement);
                    }
                }
                catch (IOException ex) {
                    String msg = String.format("Upgrade SQL file does not exist: %s", updateFile);
                    throw new DatabaseException(msg, ex);
                }
            }
            int e0 = Integer.parseInt(appExpectedVersion.getVersionParts().get(0));
            int c0 = Integer.parseInt(currentDbVersion.getVersionParts().get(0));
            int e1 = Integer.parseInt(appExpectedVersion.getVersionParts().get(1));
            int c1 = Integer.parseInt(currentDbVersion.getVersionParts().get(1));
            if (e0 == c0 && e1 < c1) {
                LOGGER.warn("A new version of dependency-check is available; consider upgrading");
                this.settings.setBoolean("autoupdate", false);
            } else if (e0 != c0 || e1 != c1) {
                LOGGER.error("The database schema must be upgraded to use this version of dependency-check. Please see {} for more information.", (Object)UPGRADE_HELP_URL);
                throw new DatabaseException("Database schema is out of date");
            }
        }
    }

    private void ensureSchemaVersion(Connection conn) throws DatabaseException {
        PreparedStatement ps;
        ResultSet rs;
        block9: {
            rs = null;
            ps = null;
            try {
                ps = conn.prepareStatement("SELECT value FROM properties WHERE id = 'version'");
                rs = ps.executeQuery();
                if (rs.next()) {
                    String dbSchemaVersion = this.settings.getString("data.version");
                    DependencyVersion appDbVersion = DependencyVersionUtil.parseVersion(dbSchemaVersion);
                    if (appDbVersion == null) {
                        throw new DatabaseException("Invalid application database schema");
                    }
                    DependencyVersion db = DependencyVersionUtil.parseVersion(rs.getString(1));
                    if (db == null) {
                        throw new DatabaseException("Invalid database schema");
                    }
                    LOGGER.debug("DC Schema: {}", (Object)appDbVersion.toString());
                    LOGGER.debug("DB Schema: {}", (Object)db.toString());
                    if (appDbVersion.compareTo(db) > 0) {
                        this.updateSchema(conn, appDbVersion, db);
                        if (++this.callDepth < 10) {
                            this.ensureSchemaVersion(conn);
                        }
                    }
                    break block9;
                }
                throw new DatabaseException("Database schema is missing");
            }
            catch (SQLException ex) {
                try {
                    LOGGER.debug("", (Throwable)ex);
                    throw new DatabaseException("Unable to check the database schema version", ex);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(rs);
                    DBUtils.closeStatement(ps);
                    throw throwable;
                }
            }
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(ps);
    }
}

