/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.hints;

import java.util.ArrayList;
import java.util.List;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.xml.hints.HintRule;
import org.owasp.dependencycheck.xml.hints.VendorDuplicatingHintRule;
import org.owasp.dependencycheck.xml.suppression.PropertyType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HintHandler
extends DefaultHandler {
    private static final String HINT = "hint";
    private static final String GIVEN = "given";
    private static final String ADD = "add";
    private static final String EVIDENCE = "evidence";
    private static final String FILE_NAME = "fileName";
    private static final String VENDOR_DUPLICATING_RULE = "vendorDuplicatingHint";
    private static final String DUPLICATE = "duplicate";
    private static final String VENDOR = "vendor";
    private static final String PRODUCT = "product";
    private static final String VERSION = "version";
    private static final String CONFIDENCE = "confidence";
    private static final String VALUE = "value";
    private static final String NAME = "name";
    private static final String SOURCE = "source";
    private static final String TYPE = "type";
    private static final String CASE_SENSITIVE = "caseSensitive";
    private static final String REGEX = "regex";
    private static final String CONTAINS = "contains";
    private final List<HintRule> hintRules = new ArrayList<HintRule>();
    private final List<VendorDuplicatingHintRule> vendorDuplicatingHintRules = new ArrayList<VendorDuplicatingHintRule>();
    private HintRule rule;
    private boolean inAddNode = false;

    public List<HintRule> getHintRules() {
        return this.hintRules;
    }

    public List<VendorDuplicatingHintRule> getVendorDuplicatingHintRules() {
        return this.vendorDuplicatingHintRules;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        if (HINT.equals(qName)) {
            this.rule = new HintRule();
        } else if (ADD.equals(qName)) {
            this.inAddNode = true;
        } else if (GIVEN.equals(qName)) {
            this.inAddNode = false;
        } else if (EVIDENCE.equals(qName)) {
            String hintType = attr.getValue(TYPE);
            if (VENDOR.equals(hintType)) {
                if (this.inAddNode) {
                    this.rule.addAddVendor(attr.getValue(SOURCE), attr.getValue(NAME), attr.getValue(VALUE), Confidence.valueOf(attr.getValue(CONFIDENCE)));
                } else {
                    this.rule.addGivenVendor(attr.getValue(SOURCE), attr.getValue(NAME), attr.getValue(VALUE), Confidence.valueOf(attr.getValue(CONFIDENCE)));
                }
            } else if (PRODUCT.equals(hintType)) {
                if (this.inAddNode) {
                    this.rule.addAddProduct(attr.getValue(SOURCE), attr.getValue(NAME), attr.getValue(VALUE), Confidence.valueOf(attr.getValue(CONFIDENCE)));
                } else {
                    this.rule.addGivenProduct(attr.getValue(SOURCE), attr.getValue(NAME), attr.getValue(VALUE), Confidence.valueOf(attr.getValue(CONFIDENCE)));
                }
            } else if (VERSION.equals(hintType) && this.inAddNode) {
                this.rule.addAddVersion(attr.getValue(SOURCE), attr.getValue(NAME), attr.getValue(VALUE), Confidence.valueOf(attr.getValue(CONFIDENCE)));
            }
        } else if (FILE_NAME.equals(qName)) {
            PropertyType pt = new PropertyType();
            pt.setValue(attr.getValue(CONTAINS));
            if (attr.getLength() > 0) {
                String caseSensitive;
                String regex = attr.getValue(REGEX);
                if (regex != null) {
                    pt.setRegex(Boolean.parseBoolean(regex));
                }
                if ((caseSensitive = attr.getValue(CASE_SENSITIVE)) != null) {
                    pt.setCaseSensitive(Boolean.parseBoolean(caseSensitive));
                }
            }
            this.rule.addFilename(pt);
        } else if (VENDOR_DUPLICATING_RULE.equals(qName)) {
            this.vendorDuplicatingHintRules.add(new VendorDuplicatingHintRule(attr.getValue(VALUE), attr.getValue(DUPLICATE)));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (HINT.equals(qName) && this.rule != null) {
            this.hintRules.add(this.rule);
            this.rule = null;
        }
    }
}

