/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.util.Iterator;
import java.util.Objects;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.dependency.EvidenceCollection;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionFilterAnalyzer
extends AbstractAnalyzer {
    private static final String FILE = "file";
    private static final String POM = "pom";
    private static final String NEXUS = "nexus";
    private static final String CENTRAL = "central";
    private static final String MANIFEST = "Manifest";
    private static final String VERSION = "version";
    private static final String IMPLEMENTATION_VERSION = "Implementation-Version";
    private static final String ANALYZER_NAME = "Version Filter Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.POST_INFORMATION_COLLECTION;
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionFilterAnalyzer.class);

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.versionfilter.enabled";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        String fileVersion = null;
        String pomVersion = null;
        String manifestVersion = null;
        for (Evidence e : dependency.getVersionEvidence()) {
            if (FILE.equals(e.getSource()) && VERSION.equals(e.getName())) {
                fileVersion = e.getValue(Boolean.FALSE);
                continue;
            }
            if ((NEXUS.equals(e.getSource()) || CENTRAL.equals(e.getSource()) || POM.equals(e.getSource())) && VERSION.equals(e.getName())) {
                pomVersion = e.getValue(Boolean.FALSE);
                continue;
            }
            if (!MANIFEST.equals(e.getSource()) || !IMPLEMENTATION_VERSION.equals(e.getName())) continue;
            manifestVersion = e.getValue(Boolean.FALSE);
        }
        if ((fileVersion == null ? 0 : 1) + (pomVersion == null ? 0 : 1) + (manifestVersion == null ? 0 : 1) > 1) {
            boolean pomMatch;
            DependencyVersion dvFile = new DependencyVersion(fileVersion);
            DependencyVersion dvPom = new DependencyVersion(pomVersion);
            DependencyVersion dvManifest = new DependencyVersion(manifestVersion);
            boolean fileMatch = Objects.equals(dvFile, dvPom) || Objects.equals(dvFile, dvManifest);
            boolean manifestMatch = Objects.equals(dvManifest, dvPom) || Objects.equals(dvManifest, dvFile);
            boolean bl = pomMatch = Objects.equals(dvPom, dvFile) || Objects.equals(dvPom, dvManifest);
            if (fileMatch || manifestMatch || pomMatch) {
                EvidenceCollection versionEvidence;
                LOGGER.debug("filtering evidence from {}", (Object)dependency.getFileName());
                EvidenceCollection evidenceCollection = versionEvidence = dependency.getVersionEvidence();
                synchronized (evidenceCollection) {
                    Iterator<Evidence> itr = versionEvidence.iterator();
                    while (itr.hasNext()) {
                        Evidence e = itr.next();
                        if (pomMatch && VERSION.equals(e.getName()) && (NEXUS.equals(e.getSource()) || CENTRAL.equals(e.getSource()) || POM.equals(e.getSource())) || fileMatch && VERSION.equals(e.getName()) && FILE.equals(e.getSource()) || manifestMatch && MANIFEST.equals(e.getSource()) && IMPLEMENTATION_VERSION.equals(e.getName())) continue;
                        itr.remove();
                    }
                }
            }
        }
    }
}

