/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.util;

import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLookup {
    public static final long DEFAULT_TIMEOUT = 10000L;

    public static <T> T getService(BundleContext bc, String className) {
        return ServiceLookup.getService(bc, className, 10000L, "");
    }

    public static <T> T getService(BundleContext bc, Class<T> type) {
        return ServiceLookup.getService(bc, type, 10000L);
    }

    public static <T> T getService(BundleContext bc, Class<T> type, Map<String, String> props) {
        return ServiceLookup.getService(bc, type, 10000L, props);
    }

    public static <T> T getService(BundleContext bc, Class<T> type, long timeout, Map<String, String> props) {
        return ServiceLookup.getService(bc, type.getName(), timeout, props);
    }

    public static <T> T getService(BundleContext bc, Class<T> type, long timeout) {
        return ServiceLookup.getService(bc, type.getName(), timeout, "");
    }

    public static <T> T getService(BundleContext bc, Class<T> type, long timeout, String filter) {
        return ServiceLookup.getService(bc, type.getName(), timeout, filter);
    }

    public static <T> T getService(BundleContext bc, String className, long timeout, Map<String, String> props) {
        ServiceTracker tracker = ServiceLookup.createServiceTracker(bc, className, props);
        try {
            tracker.open();
            Object svc = tracker.waitForService(timeout);
            if (svc == null) {
                throw new RuntimeException("gave up waiting for service " + className);
            }
            Object object = svc;
            return (T)object;
        }
        catch (InterruptedException exc) {
            throw new RuntimeException(exc);
        }
        finally {
            tracker.close();
        }
    }

    public static <T> T getService(BundleContext bc, String className, long timeout, String filter) {
        ServiceTracker tracker = ServiceLookup.createServiceTracker(bc, className, filter);
        try {
            tracker.open();
            Object svc = tracker.waitForService(timeout);
            if (svc == null) {
                throw new RuntimeException("gave up waiting for service " + className);
            }
            Object object = svc;
            return (T)object;
        }
        catch (InterruptedException exc) {
            throw new RuntimeException(exc);
        }
        finally {
            tracker.close();
        }
    }

    private static ServiceTracker createServiceTracker(BundleContext bc, String className, Map<String, String> props) {
        if (props == null || props.isEmpty()) {
            return new ServiceTracker(bc, className, null);
        }
        StringBuilder builder = new StringBuilder("(&(objectClass=");
        builder.append(className);
        builder.append(')');
        for (Map.Entry<String, String> entry : props.entrySet()) {
            builder.append('(');
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(entry.getValue());
            builder.append(')');
        }
        builder.append(')');
        try {
            Filter filter = bc.createFilter(builder.toString());
            ServiceTracker tracker = new ServiceTracker(bc, filter, null);
            return tracker;
        }
        catch (InvalidSyntaxException exc) {
            throw new RuntimeException(exc);
        }
    }

    private static ServiceTracker createServiceTracker(BundleContext bc, String className, String filterString) {
        StringBuilder builder = new StringBuilder("(&(objectClass=");
        builder.append(className);
        builder.append(')');
        if (filterString != null) {
            builder.append(filterString);
        }
        builder.append(')');
        try {
            Filter filter = bc.createFilter(builder.toString());
            ServiceTracker tracker = new ServiceTracker(bc, filter, null);
            return tracker;
        }
        catch (InvalidSyntaxException exc) {
            throw new RuntimeException(exc);
        }
    }
}

