/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class NeuralQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    private final String queryText;
    private final int k;
    @Nullable
    private final String modelId;
    public static final JsonpDeserializer<NeuralQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NeuralQuery::setupNeuralQueryDeserializer);

    private NeuralQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.queryText = ApiTypeHelper.requireNonNull(builder.queryText, this, "queryText");
        this.k = ApiTypeHelper.requireNonNull(builder.k, this, "k");
        this.modelId = builder.modelId;
    }

    public static NeuralQuery of(Function<Builder, ObjectBuilder<NeuralQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Neural;
    }

    public final String field() {
        return this.field;
    }

    public final String queryText() {
        return this.queryText;
    }

    public final int k() {
        return this.k;
    }

    @Nullable
    public final String modelId() {
        return this.modelId;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        generator.write("query_text", this.queryText);
        if (this.modelId != null) {
            generator.write("model_id", this.modelId);
        }
        generator.write("k", this.k);
        generator.writeEnd();
    }

    protected static void setupNeuralQueryDeserializer(ObjectDeserializer<Builder> op) {
        NeuralQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::queryText, JsonpDeserializer.stringDeserializer(), "query_text");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::k, JsonpDeserializer.integerDeserializer(), "k");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NeuralQuery> {
        private String field;
        private String queryText;
        private Integer k;
        @Nullable
        private String modelId;

        public Builder field(@Nullable String field) {
            this.field = field;
            return this;
        }

        public Builder queryText(@Nullable String queryText) {
            this.queryText = queryText;
            return this;
        }

        public Builder modelId(@Nullable String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder k(@Nullable Integer k) {
            this.k = k;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NeuralQuery build() {
            this._checkSingleUse();
            return new NeuralQuery(this);
        }
    }
}

