/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.type;

import java.util.ArrayList;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.reaction.IReactionProcess;
import org.openscience.cdk.reaction.ReactionEngine;
import org.openscience.cdk.reaction.ReactionSpecification;
import org.openscience.cdk.reaction.type.parameters.IParameterReact;
import org.openscience.cdk.reaction.type.parameters.SetReactionCenter;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class RearrangementLonePairReaction
extends ReactionEngine
implements IReactionProcess {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(RearrangementLonePairReaction.class);

    @Override
    public ReactionSpecification getSpecification() {
        return new ReactionSpecification("http://almost.cubic.uni-koeln.de/jrg/Members/mrc/reactionDict/reactionDict#RearrangementLonePair", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @Override
    public IReactionSet initiate(IAtomContainerSet reactants, IAtomContainerSet agents) throws CDKException {
        logger.debug((Object)"initiate reaction: RearrangementLonePairReaction");
        if (reactants.getAtomContainerCount() != 1) {
            throw new CDKException("RearrangementLonePairReaction only expects one reactant");
        }
        if (agents != null) {
            throw new CDKException("RearrangementLonePairReaction don't expects agents");
        }
        IReactionSet setOfReactions = (IReactionSet)reactants.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        IAtomContainer reactant = reactants.getAtomContainer(0);
        IParameterReact ipr = super.getParameterClass(SetReactionCenter.class);
        if (ipr != null && !ipr.isSetParameter()) {
            this.setActiveCenters(reactant);
        }
        for (IAtom atomi : reactant.atoms()) {
            if (!atomi.getFlag(1024) || (atomi.getFormalCharge() == CDKConstants.UNSET ? 0 : atomi.getFormalCharge()) != 0 || reactant.getConnectedLonePairsCount(atomi) <= 0) continue;
            for (IBond bondi : reactant.getConnectedBondsList(atomi)) {
                IAtom atomj;
                if (!bondi.getFlag(1024) || bondi.getOrder() != IBond.Order.SINGLE || !(atomj = bondi.getOther(atomi)).getFlag(1024) || (atomj.getFormalCharge() == CDKConstants.UNSET ? 0 : atomj.getFormalCharge()) != 0 || reactant.getConnectedSingleElectronsCount(atomj) != 0) continue;
                for (IBond bondj : reactant.getConnectedBondsList(atomj)) {
                    IAtom atomk;
                    if (bondj.equals(bondi) || !bondj.getFlag(1024) || bondj.getOrder() != IBond.Order.DOUBLE || !(atomk = bondj.getOther(atomj)).getFlag(1024) || reactant.getConnectedSingleElectronsCount(atomk) != 0 || (atomk.getFormalCharge() == CDKConstants.UNSET ? 0 : atomk.getFormalCharge()) < 0) continue;
                    ArrayList<IAtom> atomList = new ArrayList<IAtom>();
                    atomList.add(atomi);
                    atomList.add(atomj);
                    atomList.add(atomk);
                    ArrayList<IBond> bondList = new ArrayList<IBond>();
                    bondList.add(bondi);
                    bondList.add(bondj);
                    IAtomContainerSet moleculeSet = (IAtomContainerSet)reactant.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                    moleculeSet.addAtomContainer(reactant);
                    IReaction reaction = this.mechanism.initiate(moleculeSet, atomList, bondList);
                    if (reaction == null) continue;
                    setOfReactions.addReaction(reaction);
                }
            }
        }
        return setOfReactions;
    }

    private void setActiveCenters(IAtomContainer reactant) throws CDKException {
        for (IAtom atomi : reactant.atoms()) {
            if ((atomi.getFormalCharge() == CDKConstants.UNSET ? 0 : atomi.getFormalCharge()) != 0 || reactant.getConnectedLonePairsCount(atomi) <= 0) continue;
            for (IBond bondi : reactant.getConnectedBondsList(atomi)) {
                IAtom atomj;
                if (bondi.getOrder() != IBond.Order.SINGLE || ((atomj = bondi.getOther(atomi)).getFormalCharge() == CDKConstants.UNSET ? 0 : atomj.getFormalCharge()) != 0 || reactant.getConnectedSingleElectronsCount(atomj) != 0) continue;
                for (IBond bondj : reactant.getConnectedBondsList(atomj)) {
                    IAtom atomk;
                    if (bondj.equals(bondi) || bondj.getOrder() != IBond.Order.DOUBLE || reactant.getConnectedSingleElectronsCount(atomk = bondj.getOther(atomj)) != 0 || (atomk.getFormalCharge() == CDKConstants.UNSET ? 0 : atomk.getFormalCharge()) < 0) continue;
                    atomi.setFlag(1024, true);
                    atomj.setFlag(1024, true);
                    atomk.setFlag(1024, true);
                    bondi.setFlag(1024, true);
                    bondj.setFlag(1024, true);
                }
            }
        }
    }
}

