/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.bond;

import java.util.ArrayList;
import java.util.Iterator;
import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.charges.GasteigerPEPEPartialCharges;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractBondDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.LonePairElectronChecker;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class BondPartialTChargeDescriptor
extends AbstractBondDescriptor {
    private GasteigerMarsiliPartialCharges peoe = new GasteigerMarsiliPartialCharges();
    private GasteigerPEPEPartialCharges pepe = new GasteigerPEPEPartialCharges();
    private int maxIterations = -1;
    private int maxResonStruc = -1;
    private boolean lpeChecker = true;
    private static final String[] NAMES = new String[]{"pCB"};

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#bondPartialTCharge", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 3) {
            throw new CDKException("PartialPiChargeDescriptor only expects three parameter");
        }
        if (!(params[0] instanceof Integer)) {
            throw new CDKException("The parameter must be of type Integer");
        }
        this.maxIterations = (Integer)params[0];
        if (params.length > 1 && params[1] != null) {
            if (!(params[1] instanceof Boolean)) {
                throw new CDKException("The parameter must be of type Boolean");
            }
            this.lpeChecker = (Boolean)params[1];
        }
        if (params.length > 2 && params[2] != null) {
            if (!(params[2] instanceof Integer)) {
                throw new CDKException("The parameter must be of type Integer");
            }
            this.maxResonStruc = (Integer)params[2];
        }
    }

    public Object[] getParameters() {
        Object[] params = new Object[]{this.maxIterations, this.lpeChecker, this.maxResonStruc};
        return params;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), NAMES, e);
    }

    public DescriptorValue calculate(IBond bond, IAtomContainer ac) {
        Double originalCharge1 = bond.getBegin().getCharge();
        String originalAtomtypeName1 = bond.getBegin().getAtomTypeName();
        Integer originalNeighborCount1 = bond.getBegin().getFormalNeighbourCount();
        IAtomType.Hybridization originalHybridization1 = bond.getBegin().getHybridization();
        Integer originalValency1 = bond.getBegin().getValency();
        Double originalCharge2 = bond.getEnd().getCharge();
        String originalAtomtypeName2 = bond.getEnd().getAtomTypeName();
        Integer originalNeighborCount2 = bond.getEnd().getFormalNeighbourCount();
        IAtomType.Hybridization originalHybridization2 = bond.getEnd().getHybridization();
        Integer originalValency2 = bond.getEnd().getValency();
        Double originalBondOrderSum1 = bond.getBegin().getBondOrderSum();
        IBond.Order originalMaxBondOrder1 = bond.getBegin().getMaxBondOrder();
        Double originalBondOrderSum2 = bond.getEnd().getBondOrderSum();
        IBond.Order originalMaxBondOrder2 = bond.getEnd().getMaxBondOrder();
        if (!this.isCachedAtomContainer(ac)) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)ac);
                if (this.lpeChecker) {
                    LonePairElectronChecker lpcheck = new LonePairElectronChecker();
                    lpcheck.saturate(ac);
                }
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue((Exception)((Object)e));
            }
            if (this.maxIterations != -1) {
                this.peoe.setMaxGasteigerIters((double)this.maxIterations);
            }
            if (this.maxIterations != -1) {
                this.pepe.setMaxGasteigerIters(this.maxIterations);
            }
            if (this.maxResonStruc != -1) {
                this.pepe.setMaxResoStruc(this.maxResonStruc);
            }
            try {
                double result;
                this.peoe.assignGasteigerMarsiliSigmaPartialCharges(ac, true);
                ArrayList<Double> peoeBond = new ArrayList<Double>();
                for (IBond bondi : ac.bonds()) {
                    result = Math.abs(bondi.getBegin().getCharge() - bondi.getEnd().getCharge());
                    peoeBond.add(result);
                }
                Iterator it = ac.atoms().iterator();
                while (it.hasNext()) {
                    ((IAtom)it.next()).setCharge(Double.valueOf(0.0));
                }
                this.pepe.assignGasteigerPiPartialCharges(ac, true);
                for (int i = 0; i < ac.getBondCount(); ++i) {
                    IBond bondi;
                    bondi = ac.getBond(i);
                    result = Math.abs(bondi.getBegin().getCharge() - bondi.getEnd().getCharge());
                    this.cacheDescriptorValue(bondi, ac, (IDescriptorResult)new DoubleResult((Double)peoeBond.get(i) + result));
                }
            }
            catch (Exception e) {
                return this.getDummyDescriptorValue(e);
            }
        }
        bond.getBegin().setCharge(originalCharge1);
        bond.getBegin().setAtomTypeName(originalAtomtypeName1);
        bond.getBegin().setHybridization(originalHybridization1);
        bond.getBegin().setValency(originalValency1);
        bond.getBegin().setFormalNeighbourCount(originalNeighborCount1);
        bond.getEnd().setCharge(originalCharge2);
        bond.getEnd().setAtomTypeName(originalAtomtypeName2);
        bond.getEnd().setHybridization(originalHybridization2);
        bond.getEnd().setValency(originalValency2);
        bond.getEnd().setFormalNeighbourCount(originalNeighborCount2);
        bond.getBegin().setMaxBondOrder(originalMaxBondOrder1);
        bond.getBegin().setBondOrderSum(originalBondOrderSum1);
        bond.getEnd().setMaxBondOrder(originalMaxBondOrder2);
        bond.getEnd().setBondOrderSum(originalBondOrderSum2);
        return this.getCachedDescriptorValue(bond) != null ? new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), this.getCachedDescriptorValue(bond), NAMES) : null;
    }

    public String[] getParameterNames() {
        String[] params = new String[]{"maxIterations", "lpeChecker", "maxResonStruc"};
        return params;
    }

    public Object getParameterType(String name) {
        if ("maxIterations".equals(name)) {
            return Integer.MAX_VALUE;
        }
        if ("lpeChecker".equals(name)) {
            return Boolean.TRUE;
        }
        if ("maxResonStruc".equals(name)) {
            return Integer.MAX_VALUE;
        }
        return null;
    }
}

