/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.math.qm;

import org.openscience.cdk.math.Matrix;
import org.openscience.cdk.math.Vector;
import org.openscience.cdk.math.qm.IBasis;
import org.openscience.cdk.math.qm.Orbitals;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class OneElectronJob {
    private Orbitals orbitals;
    private Vector E;
    private static ILoggingTool log = LoggingToolFactory.createLoggingTool(OneElectronJob.class);

    public OneElectronJob(Orbitals orbitals) {
        this.orbitals = orbitals;
    }

    public Vector getEnergies() {
        return this.E.duplicate();
    }

    private void sort(Matrix C, Vector E) {
        boolean changed;
        do {
            changed = false;
            for (int i = 1; i < E.size; ++i) {
                if (!(E.vector[i - 1] > E.vector[i])) continue;
                double value = E.vector[i];
                E.vector[i] = E.vector[i - 1];
                E.vector[i - 1] = value;
                for (int j = 0; j < C.rows; ++j) {
                    value = C.matrix[j][i];
                    C.matrix[j][i] = C.matrix[j][i - 1];
                    C.matrix[j][i - 1] = value;
                }
                changed = true;
            }
        } while (changed);
    }

    private Matrix calculateS(IBasis basis) {
        int size = basis.getSize();
        Matrix S = new Matrix(size, size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                S.matrix[i][j] = basis.calcS(i, j);
            }
        }
        return S;
    }

    private Matrix calculateT(IBasis basis) {
        int size = basis.getSize();
        Matrix J = new Matrix(size, size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                J.matrix[i][j] = basis.calcJ(j, i) / 2.0;
            }
        }
        return J;
    }

    private Matrix calculateV(IBasis basis) {
        int size = basis.getSize();
        Matrix V = new Matrix(size, size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                V.matrix[i][j] = basis.calcV(i, j);
            }
        }
        return V;
    }

    public Orbitals calculate() {
        long time = System.currentTimeMillis();
        IBasis basis = this.orbitals.getBasis();
        Matrix C = this.orbitals.getCoefficients().duplicate();
        Matrix S = this.calculateS(basis);
        log.debug((Object)("S = \n" + S + "\n"));
        log.debug((Object)("C = \n" + C + "\n"));
        C = C.orthonormalize(S);
        log.debug((Object)("C' = \n" + C + "\n"));
        log.debug((Object)("C't * S * C' = \n" + S.similar(C) + "\n"));
        Matrix T = this.calculateT(basis);
        log.debug((Object)("T = \n" + T + "\n"));
        Matrix V = this.calculateV(basis);
        log.debug((Object)("V = \n" + V + "\n"));
        Matrix HAO = T.add(V);
        log.debug((Object)("HAO = \n" + HAO + "\n"));
        Matrix H = HAO.similar(C);
        log.debug((Object)("H = C't * HAO * C' = \n" + H.similar(C) + "\n"));
        Matrix U = H.diagonalize(50);
        this.E = H.similar(U).getVectorFromDiagonal();
        C = C.mul(U);
        this.sort(C, this.E);
        log.debug((Object)("C(neu) = \n" + C + "\n"));
        log.debug((Object)("E = \n" + this.E + "\n"));
        for (int j = 0; j < this.E.size; ++j) {
            log.debug((Object)("E(" + (j + 1) + ".Orbital)=" + this.E.vector[j] * 27.211 + " eV"));
        }
        time = System.currentTimeMillis() - time;
        log.debug((Object)("Time = " + time + " ms"));
        time = System.currentTimeMillis();
        return new Orbitals(basis, C);
    }
}

