/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.util;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class CachedAuthenticator
extends Authenticator {
    private static final Collection<CachedAuthentication> cached = new CopyOnWriteArrayList<CachedAuthentication>();

    public static void add(CachedAuthentication ca) {
        cached.add(ca);
    }

    @Override
    protected final PasswordAuthentication getPasswordAuthentication() {
        String host = this.getRequestingHost();
        int port = this.getRequestingPort();
        for (CachedAuthentication ca : cached) {
            if (!ca.host.equals(host) || ca.port != port) continue;
            return ca.toPasswordAuthentication();
        }
        PasswordAuthentication pa = this.promptPasswordAuthentication();
        if (pa != null) {
            CachedAuthentication ca;
            ca = new CachedAuthentication(host, port, pa.getUserName(), new String(pa.getPassword()));
            CachedAuthenticator.add(ca);
            return ca.toPasswordAuthentication();
        }
        return null;
    }

    protected abstract PasswordAuthentication promptPasswordAuthentication();

    public static class CachedAuthentication {
        final String host;
        final int port;
        final String user;
        final String pass;

        public CachedAuthentication(String aHost, int aPort, String aUser, String aPass) {
            this.host = aHost;
            this.port = aPort;
            this.user = aUser;
            this.pass = aPass;
        }

        PasswordAuthentication toPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.pass.toCharArray());
        }
    }
}

