/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marker.ci;

import java.util.Collections;
import java.util.UUID;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.OperatingSystemProvenance;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.marker.ci.IncompleteGitConfigException;

public final class DroneBuildEnvironment
implements BuildEnvironment {
    private final UUID id;
    private final String buildId;
    private final String host;
    private final String job;
    private final String branch;
    private final String tag;
    private final String remoteURL;
    private final String commitSha;

    public static DroneBuildEnvironment build(UnaryOperator<String> environment) {
        return new DroneBuildEnvironment(Tree.randomId(), (String)environment.apply("DRONE_BUILD_NUMBER"), OperatingSystemProvenance.hostname(), (String)environment.apply("DRONE_REPO"), (String)environment.apply("DRONE_BRANCH"), (String)environment.apply("DRONE_TAG"), (String)environment.apply("DRONE_REMOTE_URL"), (String)environment.apply("DRONE_COMMIT_SHA"));
    }

    @Override
    public GitProvenance buildGitProvenance() throws IncompleteGitConfigException {
        if (StringUtils.isBlank(this.remoteURL) || StringUtils.isBlank(this.branch) && StringUtils.isBlank(this.tag) || StringUtils.isBlank(this.commitSha)) {
            throw new IncompleteGitConfigException();
        }
        return new GitProvenance(UUID.randomUUID(), this.remoteURL, StringUtils.isBlank(this.branch) ? this.tag : this.branch, this.commitSha, null, null, Collections.emptyList());
    }

    public String getBuildUrl() {
        return "http://" + this.host + "/build/" + this.buildId;
    }

    @Generated
    public DroneBuildEnvironment(UUID id, String buildId, String host, String job, String branch, String tag, String remoteURL, String commitSha) {
        this.id = id;
        this.buildId = buildId;
        this.host = host;
        this.job = job;
        this.branch = branch;
        this.tag = tag;
        this.remoteURL = remoteURL;
        this.commitSha = commitSha;
    }

    @Override
    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getBuildId() {
        return this.buildId;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public String getJob() {
        return this.job;
    }

    @Generated
    public String getBranch() {
        return this.branch;
    }

    @Generated
    public String getTag() {
        return this.tag;
    }

    @Generated
    public String getRemoteURL() {
        return this.remoteURL;
    }

    @Generated
    public String getCommitSha() {
        return this.commitSha;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DroneBuildEnvironment(id=" + this.getId() + ", buildId=" + this.getBuildId() + ", host=" + this.getHost() + ", job=" + this.getJob() + ", branch=" + this.getBranch() + ", tag=" + this.getTag() + ", remoteURL=" + this.getRemoteURL() + ", commitSha=" + this.getCommitSha() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DroneBuildEnvironment)) {
            return false;
        }
        DroneBuildEnvironment other = (DroneBuildEnvironment)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$buildId = this.getBuildId();
        String other$buildId = other.getBuildId();
        if (this$buildId == null ? other$buildId != null : !this$buildId.equals(other$buildId)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$job = this.getJob();
        String other$job = other.getJob();
        if (this$job == null ? other$job != null : !this$job.equals(other$job)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$remoteURL = this.getRemoteURL();
        String other$remoteURL = other.getRemoteURL();
        if (this$remoteURL == null ? other$remoteURL != null : !this$remoteURL.equals(other$remoteURL)) {
            return false;
        }
        String this$commitSha = this.getCommitSha();
        String other$commitSha = other.getCommitSha();
        return !(this$commitSha == null ? other$commitSha != null : !this$commitSha.equals(other$commitSha));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $buildId = this.getBuildId();
        result = result * 59 + ($buildId == null ? 43 : $buildId.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : $job.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $remoteURL = this.getRemoteURL();
        result = result * 59 + ($remoteURL == null ? 43 : $remoteURL.hashCode());
        String $commitSha = this.getCommitSha();
        result = result * 59 + ($commitSha == null ? 43 : $commitSha.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public DroneBuildEnvironment withId(UUID id) {
        return this.id == id ? this : new DroneBuildEnvironment(id, this.buildId, this.host, this.job, this.branch, this.tag, this.remoteURL, this.commitSha);
    }
}

