/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Incubating;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.UnknownSourceFileChangeException;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.InMemoryDiffEntry;
import org.openrewrite.jgit.lib.FileMode;
import org.openrewrite.marker.RecipesThatMadeChanges;
import org.openrewrite.marker.SearchResult;

public class Result {
    private final @Nullable SourceFile before;
    private final @Nullable SourceFile after;
    private final Collection<List<Recipe>> recipes;
    private final @Nullable Duration timeSavings;

    public Result(@Nullable SourceFile before, @Nullable SourceFile after, Collection<List<Recipe>> recipes) {
        this.before = before;
        this.after = after;
        this.recipes = recipes;
        Duration timeSavings = null;
        for (List<Recipe> recipesStack : recipes) {
            Duration perOccurrence;
            if (recipesStack == null || recipesStack.isEmpty() || (perOccurrence = recipesStack.get(recipesStack.size() - 1).getEstimatedEffortPerOccurrence()) == null) continue;
            timeSavings = perOccurrence;
            break;
        }
        this.timeSavings = timeSavings;
    }

    public Result(@Nullable SourceFile before, SourceFile after) {
        this(before, after, after.getMarkers().findFirst(RecipesThatMadeChanges.class).orElseThrow(() -> new UnknownSourceFileChangeException(after, Result.explainWhatChanged(before, after))).getRecipes());
    }

    private static String explainWhatChanged(@Nullable SourceFile before, SourceFile after) {
        if (before == null) {
            return String.format("A new file %s was generated but no recipe reported generating it. This is likely a bug in OpenRewrite itself.", after.getSourcePath());
        }
        final HashMap beforeTrees = new HashMap();
        new TreeVisitor<Tree, Integer>(){

            @Override
            public @Nullable Tree visit(@Nullable Tree tree, Integer integer) {
                if (tree != null) {
                    beforeTrees.put(tree.getId(), tree);
                }
                return super.visit(tree, integer);
            }
        }.visit((Tree)before, (Integer)0);
        SourceFile changesMarked = (SourceFile)new TreeVisitor<Tree, Integer>(){

            @Override
            public @Nullable Tree visit(@Nullable Tree tree, Integer p) {
                if (tree != null && beforeTrees.get(tree.getId()) != tree && !Result.subtreeChanged(tree, beforeTrees)) {
                    return SearchResult.found(tree);
                }
                return super.visit(tree, p);
            }
        }.visitNonNull(after, 0);
        String diff = Result.diff(before.printAllTrimmed(), changesMarked.printAllTrimmed(), after.getSourcePath());
        return "The following diff highlights the places where unexpected changes were made:\n" + Arrays.stream(Objects.requireNonNull(diff).split("\n")).map(l -> "  " + l).collect(Collectors.joining("\n"));
    }

    private static boolean subtreeChanged(final Tree root, final Map<UUID, Tree> beforeTrees) {
        return new TreeVisitor<Tree, AtomicBoolean>(){

            @Override
            public @Nullable Tree visit(@Nullable Tree tree, AtomicBoolean changed) {
                if (tree != null && tree != root && beforeTrees.get(tree.getId()) != tree) {
                    changed.set(true);
                }
                return super.visit(tree, changed);
            }
        }.reduce(root, new AtomicBoolean(false)).get();
    }

    public List<RecipeDescriptor> getRecipeDescriptorsThatMadeChanges() {
        ArrayList<RecipeDescriptor> recipesToDisplay = new ArrayList<RecipeDescriptor>();
        for (List<Recipe> currentStack : this.recipes) {
            RecipeDescriptor index;
            Recipe root = currentStack.size() > 1 ? currentStack.get(1) : currentStack.get(0);
            RecipeDescriptor rootDescriptor = root.getDescriptor().withRecipeList(new ArrayList<RecipeDescriptor>());
            if (recipesToDisplay.contains(rootDescriptor)) {
                index = (RecipeDescriptor)recipesToDisplay.get(recipesToDisplay.indexOf(rootDescriptor));
            } else {
                recipesToDisplay.add(rootDescriptor);
                index = rootDescriptor;
            }
            for (int i = 2; i < currentStack.size(); ++i) {
                RecipeDescriptor nextDescriptor = currentStack.get(i).getDescriptor().withRecipeList(new ArrayList<RecipeDescriptor>());
                if (index.getRecipeList().contains(nextDescriptor)) {
                    index = index.getRecipeList().get(index.getRecipeList().indexOf(nextDescriptor));
                    continue;
                }
                index.getRecipeList().add(nextDescriptor);
                index = nextDescriptor;
            }
        }
        return recipesToDisplay;
    }

    public String diff() {
        return this.diff(null);
    }

    public String diff(@Nullable Path relativeTo) {
        return this.diff(relativeTo, null);
    }

    public String diff(@Nullable Path relativeTo, @Nullable PrintOutputCapture.MarkerPrinter markerPrinter) {
        return this.diff(relativeTo, markerPrinter, false);
    }

    @Incubating(since="7.34.0")
    public String diff(@Nullable Path relativeTo, @Nullable PrintOutputCapture.MarkerPrinter markerPrinter, @Nullable Boolean ignoreAllWhitespace) {
        Path beforePath = this.before == null ? null : this.before.getSourcePath();
        Path afterPath = null;
        if (this.before == null && this.after == null) {
            afterPath = (relativeTo == null ? Paths.get(".", new String[0]) : relativeTo).resolve("partial-" + System.nanoTime());
        } else if (this.after != null) {
            afterPath = this.after.getSourcePath();
        }
        PrintOutputCapture<Integer> out = markerPrinter == null ? new PrintOutputCapture<Integer>(0) : new PrintOutputCapture<Integer>(0, markerPrinter);
        FileMode beforeMode = this.before != null && this.before.getFileAttributes() != null && this.before.getFileAttributes().isExecutable() ? FileMode.EXECUTABLE_FILE : FileMode.REGULAR_FILE;
        FileMode afterMode = this.after != null && this.after.getFileAttributes() != null && this.after.getFileAttributes().isExecutable() ? FileMode.EXECUTABLE_FILE : FileMode.REGULAR_FILE;
        HashSet<Recipe> recipeSet = new HashSet<Recipe>(this.recipes.size());
        for (List<Recipe> rs : this.recipes) {
            if (rs.isEmpty()) continue;
            recipeSet.add(rs.get(0));
        }
        try (InMemoryDiffEntry diffEntry = new InMemoryDiffEntry(beforePath, afterPath, relativeTo, this.before == null ? "" : this.before.printAll(out), this.after == null ? "" : this.after.printAll(out.clone()), recipeSet, beforeMode, afterMode);){
            String string = diffEntry.getDiff(ignoreAllWhitespace);
            return string;
        }
    }

    public static @Nullable String diff(String before, String after, Path path) {
        String diff = null;
        try (InMemoryDiffEntry diffEntry = new InMemoryDiffEntry(path, path, null, before, after, Collections.emptySet(), FileMode.REGULAR_FILE, FileMode.REGULAR_FILE);){
            diff = diffEntry.getDiff(Boolean.FALSE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return diff;
    }

    public String toString() {
        return this.diff();
    }

    @Generated
    public @Nullable SourceFile getBefore() {
        return this.before;
    }

    @Generated
    public @Nullable SourceFile getAfter() {
        return this.after;
    }

    @Generated
    public Collection<List<Recipe>> getRecipes() {
        return this.recipes;
    }

    @Generated
    public @Nullable Duration getTimeSavings() {
        return this.timeSavings;
    }
}

